/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.apache.log4j.Logger;

public class ReadClusterDataStage
extends AbstractBaseStage {
    private static final Logger logger = Logger.getLogger((String)ReadClusterDataStage.class.getName());
    ClusterDataCache _cache = new ClusterDataCache();

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        logger.info((Object)"START ReadClusterDataStage.process()");
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        if (manager == null) {
            throw new StageException("HelixManager attribute value is null");
        }
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        this._cache.refresh(dataAccessor);
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute("clusterStatusMonitor");
        if (clusterStatusMonitor != null) {
            int disabledInstances = 0;
            int disabledPartitions = 0;
            for (InstanceConfig config : this._cache._instanceConfigMap.values()) {
                if (!config.getInstanceEnabled()) {
                    ++disabledInstances;
                }
                if (config.getDisabledPartitionMap() == null) continue;
                disabledPartitions += config.getDisabledPartitionMap().size();
            }
            clusterStatusMonitor.setClusterStatusCounters(this._cache._liveInstanceMap.size(), this._cache._instanceConfigMap.size(), disabledInstances, disabledPartitions);
        }
        event.addAttribute("ClusterDataCache", this._cache);
        long endTime = System.currentTimeMillis();
        logger.info((Object)("END ReadClusterDataStage.process(). took: " + (endTime - startTime) + " ms"));
    }
}

