/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.pipeline.AbstractBaseStage;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.MessageThrottleStageOutput;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.log4j.Logger;

public class TaskAssignmentStage
extends AbstractBaseStage {
    private static Logger logger = Logger.getLogger(TaskAssignmentStage.class);

    @Override
    public void process(ClusterEvent event) throws Exception {
        long startTime = System.currentTimeMillis();
        logger.info((Object)"START TaskAssignmentStage.process()");
        HelixManager manager = (HelixManager)event.getAttribute("helixmanager");
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES.toString());
        MessageThrottleStageOutput messageOutput = (MessageThrottleStageOutput)event.getAttribute(AttributeName.MESSAGES_THROTTLE.toString());
        if (manager == null || resourceMap == null || messageOutput == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires HelixManager|RESOURCES|MESSAGES_THROTTLE|DataCache");
        }
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        ArrayList<Message> messagesToSend = new ArrayList<Message>();
        for (String resourceName : resourceMap.keySet()) {
            Resource resource = (Resource)resourceMap.get(resourceName);
            for (Partition partition : resource.getPartitions()) {
                List<Message> messages = messageOutput.getMessages(resourceName, partition);
                messagesToSend.addAll(messages);
            }
        }
        List<Message> outputMessages = this.groupMessage(dataAccessor.keyBuilder(), messagesToSend, resourceMap);
        this.sendMessages(dataAccessor, outputMessages);
        long endTime = System.currentTimeMillis();
        logger.info((Object)("END TaskAssignmentStage.process(). took: " + (endTime - startTime) + " ms"));
    }

    List<Message> groupMessage(PropertyKey.Builder keyBuilder, List<Message> messages, Map<String, Resource> resourceMap) {
        HashMap<String, Message> groupMessages = new HashMap<String, Message>();
        ArrayList<Message> outputMessages = new ArrayList<Message>();
        for (Message message : messages) {
            String resourceName = message.getResourceName();
            Resource resource = resourceMap.get(resourceName);
            if (resource == null || !resource.getGroupMessageMode()) {
                outputMessages.add(message);
                continue;
            }
            String key = keyBuilder.currentState(message.getTgtName(), message.getTgtSessionId(), message.getResourceName()).getPath() + "/" + message.getFromState() + "/" + message.getToState();
            if (!groupMessages.containsKey(key)) {
                Message groupMessage = new Message(message.getRecord());
                groupMessage.setGroupMessageMode(true);
                outputMessages.add(groupMessage);
                groupMessages.put(key, groupMessage);
            }
            ((Message)groupMessages.get(key)).addPartitionName(message.getPartitionName());
        }
        return outputMessages;
    }

    protected void sendMessages(HelixDataAccessor dataAccessor, List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
        for (Message message : messages) {
            logger.info((Object)("Sending Message " + message.getMsgId() + " to " + message.getTgtName() + " transit " + message.getPartitionName() + "|" + message.getPartitionNames() + " from:" + message.getFromState() + " to:" + message.getToState()));
            keys.add(keyBuilder.message(message.getTgtName(), message.getId()));
        }
        dataAccessor.createChildren(keys, new ArrayList<Message>(messages));
    }
}

