/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;

public class DummyParticipant {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("USAGE: DummyParticipant zkAddress clusterName instanceName");
            System.exit(1);
        }
        String zkAddr = args[0];
        String clusterName = args[1];
        String instanceName = args[2];
        HelixManager manager = null;
        try {
            manager = HelixManagerFactory.getZKHelixManager(clusterName, instanceName, InstanceType.PARTICIPANT, zkAddr);
            StateMachineEngine stateMach = manager.getStateMachineEngine();
            DummyMSModelFactory msModelFactory = new DummyMSModelFactory();
            stateMach.registerStateModelFactory("MasterSlave", msModelFactory);
            manager.connect();
            Thread.currentThread().join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (manager != null) {
                manager.disconnect();
            }
        }
    }

    public static class DummyMSModelFactory
    extends StateModelFactory<DummyMSStateModel> {
        @Override
        public DummyMSStateModel createNewStateModel(String partitionName) {
            DummyMSStateModel model = new DummyMSStateModel();
            return model;
        }
    }

    @StateModelInfo(initialState="OFFLINE", states={"MASTER", "SLAVE", "ERROR"})
    public static class DummyMSStateModel
    extends StateModel {
        @Transition(to="SLAVE", from="OFFLINE")
        public void onBecomeSlaveFromOffline(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            String instanceName = message.getTgtName();
            System.out.println(instanceName + " becomes SLAVE from OFFLINE for " + partitionName);
        }

        @Transition(to="MASTER", from="SLAVE")
        public void onBecomeMasterFromSlave(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            String instanceName = message.getTgtName();
            System.out.println(instanceName + " becomes MASTER from SLAVE for " + partitionName);
        }

        @Transition(to="SLAVE", from="MASTER")
        public void onBecomeSlaveFromMaster(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            String instanceName = message.getTgtName();
            System.out.println(instanceName + " becomes SLAVE from MASTER for " + partitionName);
        }

        @Transition(to="OFFLINE", from="SLAVE")
        public void onBecomeOfflineFromSlave(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            String instanceName = message.getTgtName();
            System.out.println(instanceName + " becomes OFFLINE from SLAVE for " + partitionName);
        }

        @Transition(to="DROPPED", from="OFFLINE")
        public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            String instanceName = message.getTgtName();
            System.out.println(instanceName + " becomes DROPPED from OFFLINE for " + partitionName);
        }

        @Transition(to="OFFLINE", from="ERROR")
        public void onBecomeOfflineFromError(Message message, NotificationContext context) {
            String partitionName = message.getPartitionName();
            String instanceName = message.getTgtName();
            System.out.println(instanceName + " becomes OFFLINE from ERROR for " + partitionName);
        }

        @Override
        public void reset() {
            System.out.println("Default MockMSStateModel.reset() invoked");
        }
    }
}

