/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.healthcheck;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.ConfigScope;
import org.apache.helix.ConfigScopeBuilder;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.controller.pipeline.Pipeline;
import org.apache.helix.controller.pipeline.Stage;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.ReadHealthDataStage;
import org.apache.helix.controller.stages.StatsAggregationStage;
import org.apache.helix.monitoring.mbeans.ClusterAlertMBeanCollection;
import org.apache.helix.monitoring.mbeans.HelixStageLatencyMonitor;
import org.apache.log4j.Logger;

public class HealthStatsAggregationTask
extends HelixTimerTask {
    private static final Logger LOG = Logger.getLogger(HealthStatsAggregationTask.class);
    public static final int DEFAULT_HEALTH_CHECK_LATENCY = 30000;
    private Timer _timer;
    private final HelixManager _manager;
    private final Pipeline _healthStatsAggregationPipeline;
    private final int _delay;
    private final int _period;
    private final ClusterAlertMBeanCollection _alertItemCollection;
    private final Map<String, HelixStageLatencyMonitor> _stageLatencyMonitorMap = new HashMap<String, HelixStageLatencyMonitor>();

    public HealthStatsAggregationTask(HelixManager manager, int delay, int period) {
        this._manager = manager;
        this._delay = delay;
        this._period = period;
        this._healthStatsAggregationPipeline = new Pipeline();
        this._healthStatsAggregationPipeline.addStage(new ReadHealthDataStage());
        StatsAggregationStage statAggregationStage = new StatsAggregationStage();
        this._healthStatsAggregationPipeline.addStage(statAggregationStage);
        this._alertItemCollection = statAggregationStage.getClusterAlertMBeanCollection();
        this.registerStageLatencyMonitor(this._healthStatsAggregationPipeline);
    }

    public HealthStatsAggregationTask(HelixManager manager) {
        this(manager, 30000, 30000);
    }

    private void registerStageLatencyMonitor(Pipeline pipeline) {
        for (Stage stage : pipeline.getStages()) {
            String stgName = stage.getStageName();
            if (!this._stageLatencyMonitorMap.containsKey(stgName)) {
                try {
                    this._stageLatencyMonitorMap.put(stage.getStageName(), new HelixStageLatencyMonitor(this._manager.getClusterName(), stgName));
                }
                catch (Exception e) {
                    LOG.error((Object)("Couldn't create StageLatencyMonitor mbean for stage: " + stgName), (Throwable)e);
                }
                continue;
            }
            LOG.error((Object)("StageLatencyMonitor for stage: " + stgName + " already exists. Skip register it"));
        }
    }

    @Override
    public void start() {
        LOG.info((Object)"START HealthAggregationTask");
        if (this._timer == null) {
            HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
            List<String> existingHealthRecordNames = accessor.getChildNames(accessor.keyBuilder().healthReports(this._manager.getInstanceName()));
            for (String healthReportName : existingHealthRecordNames) {
                LOG.info((Object)("Removing old healthrecord " + healthReportName));
                accessor.removeProperty(accessor.keyBuilder().healthReport(this._manager.getInstanceName(), healthReportName));
            }
            this._timer = new Timer(true);
            this._timer.scheduleAtFixedRate((TimerTask)this, new Random().nextInt(this._delay), (long)this._period);
        } else {
            LOG.warn((Object)"timer already started");
        }
    }

    @Override
    public synchronized void stop() {
        LOG.info((Object)"Stop HealthAggregationTask");
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
            this._alertItemCollection.reset();
            for (HelixStageLatencyMonitor stgLatencyMonitor : this._stageLatencyMonitorMap.values()) {
                stgLatencyMonitor.reset();
            }
        } else {
            LOG.warn((Object)"timer already stopped");
        }
    }

    @Override
    public synchronized void run() {
        if (!this.isEnabled()) {
            LOG.info((Object)"HealthAggregationTask is disabled.");
            return;
        }
        if (!this._manager.isLeader()) {
            LOG.error((Object)("Cluster manager: " + this._manager.getInstanceName() + " is not leader. Pipeline will not be invoked"));
            return;
        }
        try {
            ClusterEvent event = new ClusterEvent("healthChange");
            event.addAttribute("helixmanager", this._manager);
            event.addAttribute("HelixStageLatencyMonitorMap", this._stageLatencyMonitorMap);
            this._healthStatsAggregationPipeline.handle(event);
            this._healthStatsAggregationPipeline.finish();
        }
        catch (Exception e) {
            LOG.error((Object)("Exception while executing pipeline: " + this._healthStatsAggregationPipeline), (Throwable)e);
        }
    }

    private boolean isEnabled() {
        ConfigAccessor configAccessor = this._manager.getConfigAccessor();
        boolean enabled = true;
        if (configAccessor != null) {
            ConfigScope scope = new ConfigScopeBuilder().forCluster(this._manager.getClusterName()).build();
            String isEnabled = configAccessor.get(scope, "healthChange.enabled");
            if (isEnabled != null) {
                enabled = new Boolean(isEnabled);
            }
        } else {
            LOG.debug((Object)"File-based cluster manager doesn't support disable healthChange");
        }
        return enabled;
    }
}

