/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.ConfigChangeListener;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.CurrentStateChangeListener;
import org.apache.helix.ExternalViewChangeListener;
import org.apache.helix.HealthStateChangeListener;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixManager;
import org.apache.helix.IdealStateChangeListener;
import org.apache.helix.LiveInstanceChangeListener;
import org.apache.helix.MessageListener;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.manager.zk.ZKExceptionHandler;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HealthStat;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class CallbackHandler
implements IZkChildListener,
IZkDataListener {
    private static Logger logger = Logger.getLogger(CallbackHandler.class);
    private final String _path;
    private final Object _listener;
    private final Watcher.Event.EventType[] _eventTypes;
    private final HelixDataAccessor _accessor;
    private final HelixConstants.ChangeType _changeType;
    private final ZkClient _zkClient;
    private final AtomicLong lastNotificationTimeStamp;
    private final HelixManager _manager;

    public CallbackHandler(HelixManager manager, ZkClient client, String path, Object listener, Watcher.Event.EventType[] eventTypes, HelixConstants.ChangeType changeType) {
        this._manager = manager;
        this._accessor = manager.getHelixDataAccessor();
        this._zkClient = client;
        this._path = path;
        this._listener = listener;
        this._eventTypes = eventTypes;
        this._changeType = changeType;
        this.lastNotificationTimeStamp = new AtomicLong(System.nanoTime());
        this.init();
    }

    public Object getListener() {
        return this._listener;
    }

    public String getPath() {
        return this._path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(NotificationContext changeContext) throws Exception {
        HelixManager helixManager = this._manager;
        synchronized (helixManager) {
            MessageListener messageListener;
            PropertyKey.Builder keyBuilder = this._accessor.keyBuilder();
            long start = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info((Object)(Thread.currentThread().getId() + " START:INVOKE " + this._path + " listener:" + this._listener.getClass().getCanonicalName()));
            }
            if (this._changeType == HelixConstants.ChangeType.IDEAL_STATE) {
                IdealStateChangeListener idealStateChangeListener = (IdealStateChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                List<IdealState> idealStates = this._accessor.getChildValues(keyBuilder.idealStates());
                idealStateChangeListener.onIdealStateChange(idealStates, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CONFIG) {
                ConfigChangeListener configChangeListener = (ConfigChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                List<InstanceConfig> configs = this._accessor.getChildValues(keyBuilder.instanceConfigs());
                configChangeListener.onConfigChange(configs, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.LIVE_INSTANCE) {
                LiveInstanceChangeListener liveInstanceChangeListener = (LiveInstanceChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                List<LiveInstance> liveInstances = this._accessor.getChildValues(keyBuilder.liveInstances());
                liveInstanceChangeListener.onLiveInstanceChange(liveInstances, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CURRENT_STATE) {
                CurrentStateChangeListener currentStateChangeListener = (CurrentStateChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                String[] pathParts = this._path.split("/");
                List<CurrentState> currentStates = this._accessor.getChildValues(keyBuilder.currentStates(instanceName, pathParts[pathParts.length - 1]));
                currentStateChangeListener.onStateChange(instanceName, currentStates, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.MESSAGE) {
                messageListener = (MessageListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, false);
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                List<Message> messages = this._accessor.getChildValues(keyBuilder.messages(instanceName));
                messageListener.onMessage(instanceName, messages, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.MESSAGES_CONTROLLER) {
                messageListener = (MessageListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, false);
                List<Message> messages = this._accessor.getChildValues(keyBuilder.controllerMessages());
                messageListener.onMessage(this._manager.getInstanceName(), messages, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.EXTERNAL_VIEW) {
                ExternalViewChangeListener externalViewListener = (ExternalViewChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                List<ExternalView> externalViewList = this._accessor.getChildValues(keyBuilder.externalViews());
                externalViewListener.onExternalViewChange(externalViewList, changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.CONTROLLER) {
                ControllerChangeListener controllerChangelistener = (ControllerChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, false);
                controllerChangelistener.onControllerChange(changeContext);
            } else if (this._changeType == HelixConstants.ChangeType.HEALTH) {
                HealthStateChangeListener healthStateChangeListener = (HealthStateChangeListener)this._listener;
                this.subscribeForChanges(changeContext, this._path, true, true);
                String instanceName = PropertyPathConfig.getInstanceNameFromPath(this._path);
                List<HealthStat> healthReportList = this._accessor.getChildValues(keyBuilder.healthReports(instanceName));
                healthStateChangeListener.onHealthChange(instanceName, healthReportList, changeContext);
            }
            long end = System.currentTimeMillis();
            if (logger.isInfoEnabled()) {
                logger.info((Object)(Thread.currentThread().getId() + " END:INVOKE " + this._path + " listener:" + this._listener.getClass().getCanonicalName() + " Took: " + (end - start) + "ms"));
            }
        }
    }

    private void subscribeForChanges(NotificationContext context, String path, boolean watchParent, boolean watchChild) {
        NotificationContext.Type type = context.getType();
        if (watchParent) {
            if (type == NotificationContext.Type.INIT || type == NotificationContext.Type.CALLBACK) {
                logger.info((Object)(this._manager.getInstanceName() + " subscribe child change@" + path));
                this._zkClient.subscribeChildChanges(path, this);
            } else if (type == NotificationContext.Type.FINALIZE) {
                logger.info((Object)(this._manager.getInstanceName() + " UNsubscribe child change@" + path));
                this._zkClient.unsubscribeChildChanges(path, this);
            }
        }
        if (watchChild) {
            try {
                List childNames = this._zkClient.getChildren(path);
                if (childNames == null || childNames.size() == 0) {
                    return;
                }
                for (String childName : childNames) {
                    String childPath = path + "/" + childName;
                    if (type == NotificationContext.Type.INIT || type == NotificationContext.Type.CALLBACK) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(this._manager.getInstanceName() + " subscribe data change@" + childPath));
                        }
                        this._zkClient.subscribeDataChanges(childPath, this);
                    } else if (type == NotificationContext.Type.FINALIZE) {
                        logger.info((Object)(this._manager.getInstanceName() + " UNsubscribe data change@" + childPath));
                        this._zkClient.unsubscribeDataChanges(childPath, this);
                    }
                    this.subscribeForChanges(context, childPath, watchParent, watchChild);
                }
            }
            catch (ZkNoNodeException e) {
                logger.warn((Object)("fail to subscribe child data change@" + path));
            }
        }
    }

    public Watcher.Event.EventType[] getEventTypes() {
        return this._eventTypes;
    }

    public void init() {
        this.updateNotificationTime(System.nanoTime());
        try {
            NotificationContext changeContext = new NotificationContext(this._manager);
            changeContext.setType(NotificationContext.Type.INIT);
            this.invoke(changeContext);
        }
        catch (Exception e) {
            ZKExceptionHandler.getInstance().handle(e);
        }
    }

    public void handleDataChange(String dataPath, Object data) {
        try {
            this.updateNotificationTime(System.nanoTime());
            if (dataPath != null && dataPath.startsWith(this._path)) {
                NotificationContext changeContext = new NotificationContext(this._manager);
                changeContext.setType(NotificationContext.Type.CALLBACK);
                this.invoke(changeContext);
            }
        }
        catch (Exception e) {
            ZKExceptionHandler.getInstance().handle(e);
        }
    }

    public void handleDataDeleted(String dataPath) {
        try {
            this.updateNotificationTime(System.nanoTime());
            if (dataPath != null && dataPath.startsWith(this._path)) {
                NotificationContext changeContext = new NotificationContext(this._manager);
                changeContext.setType(NotificationContext.Type.CALLBACK);
                this._zkClient.unsubscribeChildChanges(dataPath, this);
                this.invoke(changeContext);
            }
        }
        catch (Exception e) {
            ZKExceptionHandler.getInstance().handle(e);
        }
    }

    public void handleChildChange(String parentPath, List<String> currentChilds) {
        try {
            this.updateNotificationTime(System.nanoTime());
            if (parentPath != null && parentPath.startsWith(this._path)) {
                NotificationContext changeContext = new NotificationContext(this._manager);
                changeContext.setType(NotificationContext.Type.CALLBACK);
                this.invoke(changeContext);
            }
        }
        catch (Exception e) {
            ZKExceptionHandler.getInstance().handle(e);
        }
    }

    public void reset() {
        try {
            NotificationContext changeContext = new NotificationContext(this._manager);
            changeContext.setType(NotificationContext.Type.FINALIZE);
            this.invoke(changeContext);
        }
        catch (Exception e) {
            ZKExceptionHandler.getInstance().handle(e);
        }
    }

    private void updateNotificationTime(long nanoTime) {
        boolean b;
        long l = this.lastNotificationTimeStamp.get();
        while (nanoTime > l && !(b = this.lastNotificationTimeStamp.compareAndSet(l, nanoTime))) {
            l = this.lastNotificationTimeStamp.get();
        }
    }
}

