/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import org.apache.helix.HelixException;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.apache.log4j.Logger;

public class DefaultControllerMessageHandlerFactory
implements MessageHandlerFactory {
    private static Logger _logger = Logger.getLogger(DefaultControllerMessageHandlerFactory.class);

    @Override
    public MessageHandler createHandler(Message message, NotificationContext context) {
        String type = message.getMsgType();
        if (!type.equals(this.getMessageType())) {
            throw new HelixException("Unexpected msg type for message " + message.getMsgId() + " type:" + message.getMsgType());
        }
        return new DefaultControllerMessageHandler(message, context);
    }

    @Override
    public String getMessageType() {
        return Message.MessageType.CONTROLLER_MSG.toString();
    }

    @Override
    public void reset() {
    }

    public static class DefaultControllerMessageHandler
    extends MessageHandler {
        public DefaultControllerMessageHandler(Message message, NotificationContext context) {
            super(message, context);
        }

        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            String type = this._message.getMsgType();
            HelixTaskResult result = new HelixTaskResult();
            if (!type.equals(Message.MessageType.CONTROLLER_MSG.toString())) {
                throw new HelixException("Unexpected msg type for message " + this._message.getMsgId() + " type:" + this._message.getMsgType());
            }
            result.getTaskResultMap().put("ControllerResult", "msg " + this._message.getMsgId() + " from " + this._message.getMsgSrc() + " processed");
            result.setSuccess(true);
            return result;
        }

        @Override
        public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
            _logger.error((Object)("Message handling pipeline get an exception. MsgId:" + this._message.getMsgId()), (Throwable)e);
        }
    }
}

