/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.DataUpdater;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.ConfigScope;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.alerts.AlertsHolder;
import org.apache.helix.alerts.StatsHolder;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.tools.DefaultIdealStateCalculator;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.RebalanceUtil;
import org.apache.log4j.Logger;

public class ZKHelixAdmin
implements HelixAdmin {
    private final ZkClient _zkClient;
    private final ConfigAccessor _configAccessor;
    private static Logger logger = Logger.getLogger(ZKHelixAdmin.class);

    public ZKHelixAdmin(ZkClient zkClient) {
        this._zkClient = zkClient;
        this._configAccessor = new ConfigAccessor(zkClient);
    }

    public ZKHelixAdmin(String zkAddress) {
        this._zkClient = new ZkClient(zkAddress);
        this._zkClient.setZkSerializer(new ZNRecordSerializer());
        this._zkClient.waitUntilConnected(30L, TimeUnit.SECONDS);
        this._configAccessor = new ConfigAccessor(this._zkClient);
    }

    @Override
    public void addInstance(String clusterName, InstanceConfig instanceConfig) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String instanceConfigsPath = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, ConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        String nodeId = instanceConfig.getId();
        String instanceConfigPath = instanceConfigsPath + "/" + nodeId;
        if (this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("Node " + nodeId + " already exists in cluster " + clusterName);
        }
        ZKUtil.createChildren(this._zkClient, instanceConfigsPath, instanceConfig.getRecord());
        this._zkClient.createPersistent(HelixUtil.getMessagePath(clusterName, nodeId), true);
        this._zkClient.createPersistent(HelixUtil.getCurrentStateBasePath(clusterName, nodeId), true);
        this._zkClient.createPersistent(HelixUtil.getErrorsPath(clusterName, nodeId), true);
        this._zkClient.createPersistent(HelixUtil.getStatusUpdatesPath(clusterName, nodeId), true);
    }

    @Override
    public void dropInstance(String clusterName, InstanceConfig instanceConfig) {
        String instanceConfigsPath = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, ConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        String nodeId = instanceConfig.getId();
        String instanceConfigPath = instanceConfigsPath + "/" + nodeId;
        String instancePath = HelixUtil.getInstancePath(clusterName, nodeId);
        if (!this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("Node " + nodeId + " does not exist in config for cluster " + clusterName);
        }
        if (!this._zkClient.exists(instancePath)) {
            throw new HelixException("Node " + nodeId + " does not exist in instances for cluster " + clusterName);
        }
        ZKUtil.dropChildren(this._zkClient, instanceConfigsPath, instanceConfig.getRecord());
        this._zkClient.deleteRecursive(instancePath);
    }

    @Override
    public InstanceConfig getInstanceConfig(String clusterName, String instanceName) {
        String instanceConfigPath = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, ConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceName);
        if (!this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("instance" + instanceName + " does not exist in cluster " + clusterName);
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
    }

    @Override
    public void enableInstance(final String clusterName, final String instanceName, final boolean enabled) {
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        String path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, ConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceName);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster " + clusterName + ", instance: " + instanceName + ", instance config does not exist");
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", participant config is null");
                }
                InstanceConfig config = new InstanceConfig(currentData);
                config.setInstanceEnabled(enabled);
                return config.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void enablePartition(final boolean enabled, final String clusterName, final String instanceName, String resourceName, final List<String> partitionNames) {
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        String path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, ConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceName);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", instance config does not exist");
        }
        String idealStatePath = PropertyPathConfig.getPath(PropertyType.IDEALSTATES, clusterName, resourceName);
        ZNRecord idealStateRecord = null;
        try {
            idealStateRecord = (ZNRecord)baseAccessor.get(idealStatePath, null, 0);
        }
        catch (ZkNoNodeException e) {
            // empty catch block
        }
        if (idealStateRecord == null) {
            throw new HelixException("Cluster: " + clusterName + ", resource: " + resourceName + ", ideal state does not exist");
        }
        IdealState idealState = new IdealState(idealStateRecord);
        for (String partitionName : partitionNames) {
            if ((idealState.getIdealStateMode() != IdealState.IdealStateModeProperty.AUTO || idealState.getPreferenceList(partitionName) != null) && (idealState.getIdealStateMode() != IdealState.IdealStateModeProperty.CUSTOMIZED || idealState.getInstanceStateMap(partitionName) != null)) continue;
            logger.warn((Object)("Cluster: " + clusterName + ", resource: " + resourceName + ", partition: " + partitionName + ", partition does not exist in ideal state"));
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", participant config is null");
                }
                List<String> list = currentData.getListField(InstanceConfig.InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
                HashSet<String> disabledPartitions = new HashSet<String>();
                if (list != null) {
                    disabledPartitions.addAll(list);
                }
                if (enabled) {
                    disabledPartitions.removeAll(partitionNames);
                } else {
                    disabledPartitions.addAll(partitionNames);
                }
                list = new ArrayList<String>(disabledPartitions);
                Collections.sort(list);
                currentData.setListField(InstanceConfig.InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString(), list);
                return currentData;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void enableCluster(String clusterName, boolean enabled) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (enabled) {
            accessor.removeProperty(keyBuilder.pause());
        } else {
            accessor.createProperty(keyBuilder.pause(), new PauseSignal("pause"));
        }
    }

    @Override
    public void resetPartition(String clusterName, String instanceName, String resourceName, List<String> partitionNames) {
        HashSet<String> partitions;
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        LiveInstance liveInstance = (LiveInstance)accessor.getProperty(keyBuilder.liveInstance(instanceName));
        if (liveInstance == null) {
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because " + instanceName + " is not alive");
        }
        IdealState idealState = (IdealState)accessor.getProperty(keyBuilder.idealStates(resourceName));
        if (idealState == null) {
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because " + resourceName + " is not added");
        }
        HashSet<String> resetPartitionNames = new HashSet<String>(partitionNames);
        if (idealState.getIdealStateMode() == IdealState.IdealStateModeProperty.CUSTOMIZED ? !(partitions = new HashSet<String>(idealState.getRecord().getMapFields().keySet())).containsAll(resetPartitionNames) : !(partitions = new HashSet<String>(idealState.getRecord().getListFields().keySet())).containsAll(resetPartitionNames)) {
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because not all " + partitionNames + " exist");
        }
        String sessionId = liveInstance.getSessionId();
        CurrentState curState = (CurrentState)accessor.getProperty(keyBuilder.currentState(instanceName, sessionId, resourceName));
        for (String partitionName : resetPartitionNames) {
            if (curState.getState(partitionName).equals("ERROR")) continue;
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because not all " + partitionNames + " are in ERROR state");
        }
        String stateModelDef = idealState.getStateModelDefRef();
        StateModelDefinition stateModel = (StateModelDefinition)accessor.getProperty(keyBuilder.stateModelDef(stateModelDef));
        if (stateModel == null) {
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because " + stateModelDef + " is NOT found");
        }
        List messages = accessor.getChildValues(keyBuilder.messages(instanceName));
        for (Message message : messages) {
            if (!Message.MessageType.STATE_TRANSITION.toString().equalsIgnoreCase(message.getMsgType()) || !sessionId.equals(message.getTgtSessionId()) || !resourceName.equals(message.getResourceName()) || !resetPartitionNames.contains(message.getPartitionName())) continue;
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because a pending message exists: " + message);
        }
        String adminName = null;
        try {
            adminName = InetAddress.getLocalHost().getCanonicalHostName() + "-ADMIN";
        }
        catch (UnknownHostException e) {
            logger.info((Object)"Unable to get host name. Will set it to UNKNOWN, mostly ignorable", (Throwable)e);
            adminName = "UNKNOWN";
        }
        ArrayList<Message> resetMessages = new ArrayList<Message>();
        ArrayList<PropertyKey> messageKeys = new ArrayList<PropertyKey>();
        for (String partitionName : resetPartitionNames) {
            String msgId = UUID.randomUUID().toString();
            Message message = new Message(Message.MessageType.STATE_TRANSITION, msgId);
            message.setSrcName(adminName);
            message.setTgtName(instanceName);
            message.setMsgState(Message.MessageState.NEW);
            message.setPartitionName(partitionName);
            message.setResourceName(resourceName);
            message.setTgtSessionId(sessionId);
            message.setStateModelDef(stateModelDef);
            message.setFromState("ERROR");
            message.setToState(stateModel.getInitialState());
            message.setStateModelFactoryName(idealState.getStateModelFactoryName());
            resetMessages.add(message);
            messageKeys.add(keyBuilder.message(instanceName, message.getId()));
        }
        accessor.setChildren(messageKeys, resetMessages);
    }

    @Override
    public void resetInstance(String clusterName, List<String> instanceNames) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List extViews = accessor.getChildValues(keyBuilder.externalViews());
        HashSet<String> resetInstanceNames = new HashSet<String>(instanceNames);
        for (String instanceName : resetInstanceNames) {
            ArrayList<String> resetPartitionNames = new ArrayList<String>();
            for (ExternalView extView : extViews) {
                Map<String, Map<String, String>> stateMap = extView.getRecord().getMapFields();
                for (String partitionName : stateMap.keySet()) {
                    Map<String, String> instanceStateMap = stateMap.get(partitionName);
                    if (!instanceStateMap.containsKey(instanceName) || !instanceStateMap.get(instanceName).equals("ERROR")) continue;
                    resetPartitionNames.add(partitionName);
                }
                this.resetPartition(clusterName, instanceName, extView.getResourceName(), resetPartitionNames);
            }
        }
    }

    @Override
    public void resetResource(String clusterName, List<String> resourceNames) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List extViews = accessor.getChildValues(keyBuilder.externalViews());
        HashSet<String> resetResourceNames = new HashSet<String>(resourceNames);
        for (ExternalView extView : extViews) {
            if (!resetResourceNames.contains(extView.getResourceName())) continue;
            HashMap resetPartitionNames = new HashMap();
            Map<String, Map<String, String>> stateMap = extView.getRecord().getMapFields();
            for (String partitionName : stateMap.keySet()) {
                Map<String, String> instanceStateMap = stateMap.get(partitionName);
                for (String instanceName : instanceStateMap.keySet()) {
                    if (!instanceStateMap.get(instanceName).equals("ERROR")) continue;
                    if (!resetPartitionNames.containsKey(instanceName)) {
                        resetPartitionNames.put(instanceName, new ArrayList());
                    }
                    ((List)resetPartitionNames.get(instanceName)).add(partitionName);
                }
            }
            for (String instanceName : resetPartitionNames.keySet()) {
                this.resetPartition(clusterName, instanceName, extView.getResourceName(), (List)resetPartitionNames.get(instanceName));
            }
        }
    }

    @Override
    public void addCluster(String clusterName, boolean overwritePrevRecord) {
        String root = "/" + clusterName;
        if (this._zkClient.exists(root)) {
            logger.warn((Object)("Root directory exists.Cleaning the root directory:" + root + " overwritePrevRecord: " + overwritePrevRecord));
            if (overwritePrevRecord) {
                this._zkClient.deleteRecursive(root);
            } else {
                throw new HelixException("Cluster " + clusterName + " already exists");
            }
        }
        this._zkClient.createPersistent(root);
        this._zkClient.createPersistent(HelixUtil.getIdealStatePath(clusterName));
        String path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, ConfigScope.ConfigScopeProperty.CLUSTER.toString(), clusterName);
        this._zkClient.createPersistent(path, true);
        this._zkClient.writeData(path, new ZNRecord(clusterName));
        path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, ConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        this._zkClient.createPersistent(path);
        path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, ConfigScope.ConfigScopeProperty.RESOURCE.toString());
        this._zkClient.createPersistent(path);
        path = PropertyPathConfig.getPath(PropertyType.PROPERTYSTORE, clusterName, new String[0]);
        this._zkClient.createPersistent(path);
        this._zkClient.createPersistent(HelixUtil.getLiveInstancesPath(clusterName));
        this._zkClient.createPersistent(HelixUtil.getMemberInstancesPath(clusterName));
        this._zkClient.createPersistent(HelixUtil.getExternalViewPath(clusterName));
        this._zkClient.createPersistent(HelixUtil.getStateModelDefinitionPath(clusterName));
        this._zkClient.createPersistent(HelixUtil.getControllerPath(clusterName));
        path = PropertyPathConfig.getPath(PropertyType.HISTORY, clusterName, new String[0]);
        ZNRecord emptyHistory = new ZNRecord(PropertyType.HISTORY.toString());
        ArrayList<String> emptyList = new ArrayList<String>();
        emptyHistory.setListField(clusterName, emptyList);
        this._zkClient.createPersistent(path, emptyHistory);
        path = PropertyPathConfig.getPath(PropertyType.MESSAGES_CONTROLLER, clusterName, new String[0]);
        this._zkClient.createPersistent(path);
        path = PropertyPathConfig.getPath(PropertyType.STATUSUPDATES_CONTROLLER, clusterName, new String[0]);
        this._zkClient.createPersistent(path);
        path = PropertyPathConfig.getPath(PropertyType.ERRORS_CONTROLLER, clusterName, new String[0]);
        this._zkClient.createPersistent(path);
    }

    @Override
    public List<String> getInstancesInCluster(String clusterName) {
        String memberInstancesPath = HelixUtil.getMemberInstancesPath(clusterName);
        return this._zkClient.getChildren(memberInstancesPath);
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, IdealState.IdealStateModeProperty.AUTO.toString(), 0);
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String idealStateMode) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, idealStateMode, 0);
    }

    @Override
    public void addResource(String clusterName, String resourceName, IdealState idealstate) {
        String stateModelRef = idealstate.getStateModelDefRef();
        String stateModelDefPath = PropertyPathConfig.getPath(PropertyType.STATEMODELDEFS, clusterName, stateModelRef);
        if (!this._zkClient.exists(stateModelDefPath)) {
            throw new HelixException("State model " + stateModelRef + " not found in the cluster STATEMODELDEFS path");
        }
        String idealStatePath = HelixUtil.getIdealStatePath(clusterName);
        String dbIdealStatePath = idealStatePath + "/" + resourceName;
        if (this._zkClient.exists(dbIdealStatePath)) {
            throw new HelixException("Skip the operation. DB ideal state directory exists:" + dbIdealStatePath);
        }
        ZKUtil.createChildren(this._zkClient, idealStatePath, idealstate.getRecord());
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String idealStateMode, int bucketSize) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        IdealState.IdealStateModeProperty mode = IdealState.IdealStateModeProperty.AUTO;
        try {
            mode = IdealState.IdealStateModeProperty.valueOf(idealStateMode);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        IdealState idealState = new IdealState(resourceName);
        idealState.setNumPartitions(partitions);
        idealState.setStateModelDefRef(stateModelRef);
        idealState.setIdealStateMode(mode.toString());
        idealState.setReplicas("0");
        idealState.setStateModelFactoryName("DEFAULT");
        if (bucketSize > 0) {
            idealState.setBucketSize(bucketSize);
        }
        this.addResource(clusterName, resourceName, idealState);
    }

    @Override
    public List<String> getClusters() {
        List zkToplevelPathes = this._zkClient.getChildren("/");
        ArrayList<String> result = new ArrayList<String>();
        for (String pathName : zkToplevelPathes) {
            if (!ZKUtil.isClusterSetup(pathName, this._zkClient)) continue;
            result.add(pathName);
        }
        return result;
    }

    @Override
    public List<String> getResourcesInCluster(String clusterName) {
        return this._zkClient.getChildren(HelixUtil.getIdealStatePath(clusterName));
    }

    @Override
    public IdealState getResourceIdealState(String clusterName, String dbName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (IdealState)accessor.getProperty(keyBuilder.idealStates(dbName));
    }

    @Override
    public void setResourceIdealState(String clusterName, String dbName, IdealState idealState) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.idealStates(dbName), idealState);
    }

    @Override
    public ExternalView getResourceExternalView(String clusterName, String resourceName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (ExternalView)accessor.getProperty(keyBuilder.externalView(resourceName));
    }

    @Override
    public void addStateModelDef(String clusterName, String stateModelDef, StateModelDefinition stateModel) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String stateModelDefPath = HelixUtil.getStateModelDefinitionPath(clusterName);
        String stateModelPath = stateModelDefPath + "/" + stateModelDef;
        if (this._zkClient.exists(stateModelPath)) {
            logger.warn((Object)("Skip the operation.State Model directory exists:" + stateModelPath));
            throw new HelixException("State model path " + stateModelPath + " already exists.");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.stateModelDef(stateModel.getId()), stateModel);
    }

    @Override
    public void dropResource(String clusterName, String resourceName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.removeProperty(keyBuilder.idealStates(resourceName));
    }

    @Override
    public List<String> getStateModelDefs(String clusterName) {
        return this._zkClient.getChildren(HelixUtil.getStateModelDefinitionPath(clusterName));
    }

    @Override
    public StateModelDefinition getStateModelDef(String clusterName, String stateModelName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (StateModelDefinition)accessor.getProperty(keyBuilder.stateModelDef(stateModelName));
    }

    @Override
    public void addStat(String clusterName, final String statName) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String persistentStatsPath = PropertyPathConfig.getPath(PropertyType.PERSISTENTSTATS, clusterName, new String[0]);
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        baseAccessor.update(persistentStatsPath, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord statsRec) {
                if (statsRec == null) {
                    statsRec = new ZNRecord("PersistentStats");
                }
                Map<String, Map<String, String>> currStatMap = statsRec.getMapFields();
                Map<String, Map<String, String>> newStatMap = StatsHolder.parseStat(statName);
                for (String newStat : newStatMap.keySet()) {
                    if (currStatMap.containsKey(newStat)) continue;
                    currStatMap.put(newStat, newStatMap.get(newStat));
                }
                statsRec.setMapFields(currStatMap);
                return statsRec;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void addAlert(final String clusterName, final String alertName) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        String alertsPath = PropertyPathConfig.getPath(PropertyType.ALERTS, clusterName, new String[0]);
        baseAccessor.update(alertsPath, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord alertsRec) {
                if (alertsRec == null) {
                    alertsRec = new ZNRecord("Alerts");
                }
                Map<String, Map<String, String>> currAlertMap = alertsRec.getMapFields();
                StringBuilder newStatName = new StringBuilder();
                HashMap<String, String> newAlertMap = new HashMap<String, String>();
                AlertsHolder.parseAlert(alertName, newStatName, newAlertMap);
                ZKHelixAdmin.this.addStat(clusterName, newStatName.toString());
                currAlertMap.put(alertName, newAlertMap);
                alertsRec.setMapFields(currAlertMap);
                return alertsRec;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void dropCluster(String clusterName) {
        logger.info((Object)("Deleting cluster " + clusterName));
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String root = "/" + clusterName;
        if (accessor.getChildNames(keyBuilder.liveInstances()).size() > 0) {
            throw new HelixException("There are still live instances in the cluster, shut them down first.");
        }
        if (accessor.getProperty(keyBuilder.controllerLeader()) != null) {
            throw new HelixException("There are still LEADER in the cluster, shut them down first.");
        }
        this._zkClient.deleteRecursive(root);
    }

    @Override
    public void dropStat(String clusterName, final String statName) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String persistentStatsPath = PropertyPathConfig.getPath(PropertyType.PERSISTENTSTATS, clusterName, new String[0]);
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        baseAccessor.update(persistentStatsPath, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord statsRec) {
                if (statsRec == null) {
                    throw new HelixException("No stats record in ZK, nothing to drop");
                }
                Map<String, Map<String, String>> currStatMap = statsRec.getMapFields();
                Map<String, Map<String, String>> newStatMap = StatsHolder.parseStat(statName);
                for (String newStat : newStatMap.keySet()) {
                    if (!currStatMap.containsKey(newStat)) continue;
                    currStatMap.remove(newStat);
                }
                statsRec.setMapFields(currStatMap);
                return statsRec;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void dropAlert(String clusterName, final String alertName) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        String alertsPath = PropertyPathConfig.getPath(PropertyType.ALERTS, clusterName, new String[0]);
        if (!baseAccessor.exists(alertsPath, 0)) {
            throw new HelixException("No alerts node in ZK, nothing to drop");
        }
        baseAccessor.update(alertsPath, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord alertsRec) {
                if (alertsRec == null) {
                    throw new HelixException("No alerts record in ZK, nothing to drop");
                }
                Map<String, Map<String, String>> currAlertMap = alertsRec.getMapFields();
                currAlertMap.remove(alertName);
                alertsRec.setMapFields(currAlertMap);
                return alertsRec;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void addClusterToGrandCluster(String clusterName, String grandCluster) {
        if (!ZKUtil.isClusterSetup(grandCluster, this._zkClient)) {
            throw new HelixException("Grand cluster " + grandCluster + " is not setup yet");
        }
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("Cluster " + clusterName + " is not setup yet");
        }
        IdealState idealState = new IdealState(clusterName);
        idealState.setNumPartitions(1);
        idealState.setStateModelDefRef("LeaderStandby");
        List<String> controllers = this.getInstancesInCluster(grandCluster);
        if (controllers.size() == 0) {
            throw new HelixException("Grand cluster " + grandCluster + " has no instances");
        }
        idealState.setReplicas(Integer.toString(controllers.size()));
        Collections.shuffle(controllers);
        idealState.getRecord().setListField(clusterName, controllers);
        idealState.setPartitionState(clusterName, controllers.get(0), "LEADER");
        for (int i = 1; i < controllers.size(); ++i) {
            idealState.setPartitionState(clusterName, controllers.get(i), "STANDBY");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(grandCluster, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.idealStates(idealState.getResourceName()), idealState);
    }

    @Override
    public void setConfig(ConfigScope scope, Map<String, String> properties) {
        for (String key : properties.keySet()) {
            this._configAccessor.set(scope, key, properties.get(key));
        }
    }

    @Override
    public Map<String, String> getConfig(ConfigScope scope, Set<String> keys) {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        if (keys != null) {
            for (String key : keys) {
                String value = this._configAccessor.get(scope, key);
                if (value == null) {
                    logger.error((Object)("Config doesn't exist for key: " + key));
                    continue;
                }
                properties.put(key, value);
            }
        }
        return properties;
    }

    @Override
    public List<String> getConfigKeys(ConfigScope.ConfigScopeProperty scope, String clusterName, String ... keys) {
        return this._configAccessor.getKeys(scope, clusterName, keys);
    }

    @Override
    public void removeConfig(ConfigScope scope, Set<String> keys) {
        for (String key : keys) {
            this._configAccessor.remove(scope, key);
        }
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica) {
        List<String> instanceNames = this.getInstancesInCluster(clusterName);
        this.rebalance(clusterName, resourceName, replica, resourceName, instanceNames);
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica, String keyPrefix) {
        List<String> instanceNames = this.getInstancesInCluster(clusterName);
        this.rebalance(clusterName, resourceName, replica, keyPrefix, instanceNames);
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica, List<String> instances) {
        this.rebalance(clusterName, resourceName, replica, resourceName, instances);
    }

    void rebalance(String clusterName, String resourceName, int replica, String keyPrefix, List<String> instanceNames) {
        Collections.sort(instanceNames);
        IdealState idealState = this.getResourceIdealState(clusterName, resourceName);
        if (idealState == null) {
            throw new HelixException("Resource: " + resourceName + " has NOT been added yet");
        }
        idealState.setReplicas(Integer.toString(replica));
        int partitions = idealState.getNumPartitions();
        String stateModelName = idealState.getStateModelDefRef();
        StateModelDefinition stateModDef = this.getStateModelDef(clusterName, stateModelName);
        if (stateModDef == null) {
            throw new HelixException("cannot find state model: " + stateModelName);
        }
        List<String> statePriorityList = stateModDef.getStatesPriorityList();
        String masterStateValue = null;
        String slaveStateValue = null;
        --replica;
        for (String state : statePriorityList) {
            String count = stateModDef.getNumInstancesPerState(state);
            if (count.equals("1")) {
                if (masterStateValue != null) {
                    throw new HelixException("Invalid or unsupported state model definition");
                }
                masterStateValue = state;
                continue;
            }
            if (count.equalsIgnoreCase("R")) {
                if (slaveStateValue != null) {
                    throw new HelixException("Invalid or unsupported state model definition");
                }
                slaveStateValue = state;
                continue;
            }
            if (!count.equalsIgnoreCase("N")) continue;
            if (masterStateValue != null || slaveStateValue != null) {
                throw new HelixException("Invalid or unsupported state model definition");
            }
            replica = instanceNames.size() - 1;
            masterStateValue = slaveStateValue = state;
        }
        if (masterStateValue == null && slaveStateValue == null) {
            throw new HelixException("Invalid or unsupported state model definition");
        }
        if (masterStateValue == null) {
            masterStateValue = slaveStateValue;
        }
        if (idealState.getIdealStateMode() != IdealState.IdealStateModeProperty.AUTO_REBALANCE) {
            ZNRecord newIdealState = DefaultIdealStateCalculator.calculateIdealState(instanceNames, partitions, replica, keyPrefix, masterStateValue, slaveStateValue);
            if (idealState.getIdealStateMode() == IdealState.IdealStateModeProperty.AUTO) {
                idealState.getRecord().setListFields(newIdealState.getListFields());
                idealState.getRecord().setMapFields(newIdealState.getMapFields());
            }
            if (idealState.getIdealStateMode() == IdealState.IdealStateModeProperty.CUSTOMIZED) {
                idealState.getRecord().setMapFields(newIdealState.getMapFields());
            }
        } else {
            for (int i = 0; i < partitions; ++i) {
                String partitionName = keyPrefix + "_" + i;
                idealState.getRecord().setMapField(partitionName, new HashMap<String, String>());
                idealState.getRecord().setListField(partitionName, new ArrayList<String>());
            }
        }
        this.setResourceIdealState(clusterName, resourceName, idealState);
    }

    @Override
    public void addIdealState(String clusterName, String resourceName, String idealStateFile) throws IOException {
        ZNRecord idealStateRecord = (ZNRecord)new ZNRecordSerializer().deserialize(ZKHelixAdmin.readFile(idealStateFile));
        if (idealStateRecord.getId() == null || !idealStateRecord.getId().equals(resourceName)) {
            throw new IllegalArgumentException("ideal state must have same id as resource name");
        }
        this.setResourceIdealState(clusterName, resourceName, new IdealState(idealStateRecord));
    }

    private static byte[] readFile(String filePath) throws IOException {
        File file = new File(filePath);
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        int numRead = 0;
        for (int read = 0; read < bytes.length && (numRead = dis.read(bytes, read, bytes.length - read)) >= 0; read += numRead) {
        }
        return bytes;
    }

    @Override
    public void addStateModelDef(String clusterName, String stateModelDefName, String stateModelDefFile) throws IOException {
        ZNRecord record = (ZNRecord)new ZNRecordSerializer().deserialize(ZKHelixAdmin.readFile(stateModelDefFile));
        if (record == null || record.getId() == null || !record.getId().equals(stateModelDefName)) {
            throw new IllegalArgumentException("state model definition must have same id as state model def name");
        }
        this.addStateModelDef(clusterName, stateModelDefName, new StateModelDefinition(record));
    }

    @Override
    public void addMessageConstraint(String clusterName, final String constraintId, final Map<String, String> constraints) {
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        String path = keyBuilder.constraint(ClusterConstraints.ConstraintType.MESSAGE_CONSTRAINT.toString()).getPath();
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                Map<String, String> map;
                if (currentData == null) {
                    currentData = new ZNRecord(ClusterConstraints.ConstraintType.MESSAGE_CONSTRAINT.toString());
                }
                if ((map = currentData.getMapField(constraintId)) == null) {
                    map = new TreeMap<String, String>();
                    currentData.setMapField(constraintId, map);
                } else {
                    logger.warn((Object)("Overwrite existing constraint " + constraintId + ": " + map));
                }
                for (String key : constraints.keySet()) {
                    ClusterConstraints.ConstraintAttribute attr = ClusterConstraints.ConstraintAttribute.valueOf(key.toUpperCase());
                    map.put(attr.toString(), (String)constraints.get(key));
                }
                return currentData;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void rebalance(String clusterName, IdealState currentIdealState, List<String> instanceNames) {
        HashSet<String> activeInstances = new HashSet<String>();
        for (String partition : currentIdealState.getPartitionSet()) {
            activeInstances.addAll(currentIdealState.getRecord().getListField(partition));
        }
        instanceNames.removeAll(activeInstances);
        Map<String, Object> previousIdealState = RebalanceUtil.buildInternalIdealState(currentIdealState);
        Map<String, Object> balancedRecord = DefaultIdealStateCalculator.calculateNextIdealState(instanceNames, previousIdealState);
        StateModelDefinition stateModDef = this.getStateModelDef(clusterName, currentIdealState.getStateModelDefRef());
        if (stateModDef == null) {
            throw new HelixException("cannot find state model: " + currentIdealState.getStateModelDefRef());
        }
        String[] states = RebalanceUtil.parseStates(clusterName, stateModDef);
        ZNRecord newIdealStateRecord = DefaultIdealStateCalculator.convertToZNRecord(balancedRecord, currentIdealState.getResourceName(), states[0], states[1]);
        HashSet<String> partitionSet = new HashSet<String>();
        partitionSet.addAll(newIdealStateRecord.getMapFields().keySet());
        partitionSet.addAll(newIdealStateRecord.getListFields().keySet());
        Map reversePartitionIndex = (Map)balancedRecord.get("reversePartitionIndex");
        for (String partition : partitionSet) {
            String originPartitionName;
            if (!reversePartitionIndex.containsKey(partition) || partition.equals(originPartitionName = (String)reversePartitionIndex.get(partition))) continue;
            newIdealStateRecord.getMapFields().put(originPartitionName, newIdealStateRecord.getMapField(partition));
            newIdealStateRecord.getMapFields().remove(partition);
            newIdealStateRecord.getListFields().put(originPartitionName, newIdealStateRecord.getListField(partition));
            newIdealStateRecord.getListFields().remove(partition);
        }
        newIdealStateRecord.getSimpleFields().putAll(currentIdealState.getRecord().getSimpleFields());
        IdealState newIdealState = new IdealState(newIdealStateRecord);
        this.setResourceIdealState(clusterName, newIdealStateRecord.getId(), newIdealState);
    }
}

