/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.ZkConnection;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ClusterMessagingService;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.ConfigChangeListener;
import org.apache.helix.ConfigScope;
import org.apache.helix.ControllerChangeListener;
import org.apache.helix.CurrentStateChangeListener;
import org.apache.helix.ExternalViewChangeListener;
import org.apache.helix.HealthStateChangeListener;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.IdealStateChangeListener;
import org.apache.helix.InstanceType;
import org.apache.helix.LiveInstanceChangeListener;
import org.apache.helix.MessageListener;
import org.apache.helix.PreConnectCallback;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.restlet.ZKPropertyTransferServer;
import org.apache.helix.healthcheck.HealthStatsAggregationTask;
import org.apache.helix.healthcheck.ParticipantHealthReportCollector;
import org.apache.helix.healthcheck.ParticipantHealthReportCollectorImpl;
import org.apache.helix.manager.zk.ByteArraySerializer;
import org.apache.helix.manager.zk.CallbackHandler;
import org.apache.helix.manager.zk.ChainedPathZkSerializer;
import org.apache.helix.manager.zk.DefaultControllerMessageHandlerFactory;
import org.apache.helix.manager.zk.DefaultParticipantErrorMessageHandlerFactory;
import org.apache.helix.manager.zk.DefaultSchedulerMessageHandlerFactory;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.ZNRecordStreamingSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkCacheBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.manager.zk.ZkStateChangeListener;
import org.apache.helix.messaging.DefaultMessagingService;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.monitoring.ZKPathDataDumpTask;
import org.apache.helix.participant.DistClusterControllerElection;
import org.apache.helix.participant.HelixStateMachineEngine;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.tools.PropertiesReader;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class ZKHelixManager
implements HelixManager {
    private static Logger logger = Logger.getLogger(ZKHelixManager.class);
    private static final int RETRY_LIMIT = 3;
    private static final int CONNECTIONTIMEOUT = 60000;
    private final String _clusterName;
    private final String _instanceName;
    private final String _zkConnectString;
    private static final int DEFAULT_SESSION_TIMEOUT = 30000;
    private ZKHelixDataAccessor _helixAccessor;
    private ConfigAccessor _configAccessor;
    protected ZkClient _zkClient;
    private final List<CallbackHandler> _handlers;
    private final ZkStateChangeListener _zkStateChangeListener;
    private final InstanceType _instanceType;
    volatile String _sessionId;
    private Timer _timer;
    private CallbackHandler _leaderElectionHandler;
    private ParticipantHealthReportCollectorImpl _participantHealthCheckInfoCollector;
    private final DefaultMessagingService _messagingService;
    private ZKHelixAdmin _managementTool;
    private final String _version;
    private final StateMachineEngine _stateMachEngine;
    private int _sessionTimeout;
    private ZkHelixPropertyStore<ZNRecord> _helixPropertyStore;
    private final List<HelixTimerTask> _controllerTimerTasks;
    private BaseDataAccessor<ZNRecord> _baseDataAccessor;
    List<PreConnectCallback> _preConnectCallbacks = new LinkedList<PreConnectCallback>();
    ZKPropertyTransferServer _transferServer = null;

    public ZKHelixManager(String clusterName, String instanceName, InstanceType instanceType, String zkConnectString) throws Exception {
        logger.info((Object)("Create a zk-based cluster manager. clusterName:" + clusterName + ", instanceName:" + instanceName + ", type:" + (Object)((Object)instanceType) + ", zkSvr:" + zkConnectString));
        int sessionTimeoutInt = -1;
        try {
            sessionTimeoutInt = Integer.parseInt(System.getProperty("zk.session.timeout", "30000"));
        }
        catch (NumberFormatException e) {
            logger.warn((Object)("Exception while parsing session timeout: " + System.getProperty("zk.session.timeout", "30000")));
        }
        this._sessionTimeout = sessionTimeoutInt > 0 ? sessionTimeoutInt : 30000;
        if (instanceName == null) {
            try {
                instanceName = InetAddress.getLocalHost().getCanonicalHostName() + "-" + instanceType.toString();
            }
            catch (UnknownHostException e) {
                logger.info((Object)"Unable to get host name. Will set it to UNKNOWN, mostly ignorable", (Throwable)e);
                instanceName = "UNKNOWN";
            }
        }
        this._clusterName = clusterName;
        this._instanceName = instanceName;
        this._instanceType = instanceType;
        this._zkConnectString = zkConnectString;
        this._zkStateChangeListener = new ZkStateChangeListener(this);
        this._timer = null;
        this._handlers = new ArrayList<CallbackHandler>();
        this._messagingService = new DefaultMessagingService(this);
        this._version = new PropertiesReader("cluster-manager-version.properties").getProperty("clustermanager.version");
        this._stateMachEngine = new HelixStateMachineEngine(this);
        this._controllerTimerTasks = new ArrayList<HelixTimerTask>();
        if (this._instanceType == InstanceType.CONTROLLER) {
            this._controllerTimerTasks.add(new HealthStatsAggregationTask(this));
        }
    }

    private boolean isInstanceSetup() {
        if (this._instanceType == InstanceType.PARTICIPANT || this._instanceType == InstanceType.CONTROLLER_PARTICIPANT) {
            boolean isValid = this._zkClient.exists(PropertyPathConfig.getPath(PropertyType.CONFIGS, this._clusterName, ConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), this._instanceName)) && this._zkClient.exists(PropertyPathConfig.getPath(PropertyType.MESSAGES, this._clusterName, this._instanceName)) && this._zkClient.exists(PropertyPathConfig.getPath(PropertyType.CURRENTSTATES, this._clusterName, this._instanceName)) && this._zkClient.exists(PropertyPathConfig.getPath(PropertyType.STATUSUPDATES, this._clusterName, this._instanceName)) && this._zkClient.exists(PropertyPathConfig.getPath(PropertyType.ERRORS, this._clusterName, this._instanceName));
            return isValid;
        }
        return true;
    }

    @Override
    public void addIdealStateChangeListener(IdealStateChangeListener listener) throws Exception {
        logger.info((Object)"ClusterManager.addIdealStateChangeListener()");
        this.checkConnected();
        String path = PropertyPathConfig.getPath(PropertyType.IDEALSTATES, this._clusterName, new String[0]);
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeDataChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.IDEAL_STATE);
        this.addListener(callbackHandler);
    }

    @Override
    public void addLiveInstanceChangeListener(LiveInstanceChangeListener listener) throws Exception {
        logger.info((Object)"ClusterManager.addLiveInstanceChangeListener()");
        this.checkConnected();
        String path = this._helixAccessor.keyBuilder().liveInstances().getPath();
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeDataChanged, Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.LIVE_INSTANCE);
        this.addListener(callbackHandler);
    }

    @Override
    public void addConfigChangeListener(ConfigChangeListener listener) {
        logger.info((Object)"ClusterManager.addConfigChangeListener()");
        this.checkConnected();
        String path = PropertyPathConfig.getPath(PropertyType.CONFIGS, this._clusterName, ConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged}, HelixConstants.ChangeType.CONFIG);
        this.addListener(callbackHandler);
    }

    @Override
    public void addMessageListener(MessageListener listener, String instanceName) {
        logger.info((Object)("ClusterManager.addMessageListener() " + instanceName));
        this.checkConnected();
        String path = this._helixAccessor.keyBuilder().messages(instanceName).getPath();
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.MESSAGE);
        this.addListener(callbackHandler);
    }

    void addControllerMessageListener(MessageListener listener) {
        logger.info((Object)"ClusterManager.addControllerMessageListener()");
        this.checkConnected();
        String path = this._helixAccessor.keyBuilder().controllerMessages().getPath();
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.MESSAGES_CONTROLLER);
        this.addListener(callbackHandler);
    }

    @Override
    public void addCurrentStateChangeListener(CurrentStateChangeListener listener, String instanceName, String sessionId) {
        logger.info((Object)("ClusterManager.addCurrentStateChangeListener() " + instanceName + " " + sessionId));
        this.checkConnected();
        String path = this._helixAccessor.keyBuilder().currentStates(instanceName, sessionId).getPath();
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.CURRENT_STATE);
        this.addListener(callbackHandler);
    }

    @Override
    public void addHealthStateChangeListener(HealthStateChangeListener listener, String instanceName) {
        logger.info((Object)("ClusterManager.addHealthStateChangeListener()" + instanceName));
        this.checkConnected();
        String path = this._helixAccessor.keyBuilder().healthReports(instanceName).getPath();
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDataChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.HEALTH);
        this.addListener(callbackHandler);
    }

    @Override
    public void addExternalViewChangeListener(ExternalViewChangeListener listener) {
        logger.info((Object)"ClusterManager.addExternalViewChangeListener()");
        this.checkConnected();
        String path = this._helixAccessor.keyBuilder().externalViews().getPath();
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeDataChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.EXTERNAL_VIEW);
        this.addListener(callbackHandler);
    }

    @Override
    public HelixDataAccessor getHelixDataAccessor() {
        this.checkConnected();
        return this._helixAccessor;
    }

    @Override
    public ConfigAccessor getConfigAccessor() {
        this.checkConnected();
        return this._configAccessor;
    }

    @Override
    public String getClusterName() {
        return this._clusterName;
    }

    @Override
    public String getInstanceName() {
        return this._instanceName;
    }

    @Override
    public void connect() throws Exception {
        logger.info((Object)"ClusterManager.connect()");
        if (this._zkStateChangeListener.isConnected()) {
            logger.warn((Object)("Cluster manager " + this._clusterName + " " + this._instanceName + " already connected"));
            return;
        }
        try {
            this.createClient(this._zkConnectString);
            this._messagingService.onConnected();
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.disconnect();
            throw e;
        }
    }

    @Override
    public void disconnect() {
        if (!this.isConnected()) {
            logger.warn((Object)("ClusterManager " + this._instanceName + " already disconnected"));
            return;
        }
        logger.info((Object)("disconnect " + this._instanceName + "(" + (Object)((Object)this._instanceType) + ") from " + this._clusterName));
        this._messagingService.getExecutor().shutDown();
        this.resetHandlers();
        this._helixAccessor.shutdown();
        if (this._leaderElectionHandler != null) {
            this._leaderElectionHandler.reset();
        }
        if (this._participantHealthCheckInfoCollector != null) {
            this._participantHealthCheckInfoCollector.stop();
        }
        if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
        if (this._instanceType == InstanceType.CONTROLLER) {
            this.stopTimerTasks();
        }
        this._zkClient.unsubscribeAll();
        this._zkClient.close();
        this._zkStateChangeListener.disconnect();
        logger.info((Object)("Cluster manager: " + this._instanceName + " disconnected"));
    }

    @Override
    public String getSessionId() {
        this.checkConnected();
        return this._sessionId;
    }

    @Override
    public boolean isConnected() {
        return this._zkStateChangeListener.isConnected();
    }

    @Override
    public long getLastNotificationTime() {
        return -1L;
    }

    @Override
    public void addControllerListener(ControllerChangeListener listener) {
        this.checkConnected();
        String path = this._helixAccessor.keyBuilder().controller().getPath();
        logger.info((Object)("Add controller listener at: " + path));
        CallbackHandler callbackHandler = this.createCallBackHandler(path, listener, new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.CONTROLLER);
        this.addListener(callbackHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(Object listener) {
        logger.info((Object)("remove listener: " + listener + " from " + this._instanceName));
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            Iterator<CallbackHandler> iterator = this._handlers.iterator();
            while (iterator.hasNext()) {
                CallbackHandler handler = iterator.next();
                if (!handler.getListener().equals(listener)) continue;
                handler.reset();
                iterator.remove();
            }
        }
        return true;
    }

    private void addLiveInstance() {
        LiveInstance liveInstance = new LiveInstance(this._instanceName);
        liveInstance.setSessionId(this._sessionId);
        liveInstance.setHelixVersion(this._version);
        liveInstance.setLiveInstance(ManagementFactory.getRuntimeMXBean().getName());
        logger.info((Object)("Add live instance: InstanceName: " + this._instanceName + " Session id:" + this._sessionId));
        PropertyKey.Builder keyBuilder = this._helixAccessor.keyBuilder();
        if (!this._helixAccessor.createProperty(keyBuilder.liveInstance(this._instanceName), liveInstance)) {
            String errorMsg = "Fail to create live instance node after waiting, so quit. instance:" + this._instanceName;
            logger.warn((Object)errorMsg);
            throw new HelixException(errorMsg);
        }
        String currentStatePathParent = PropertyPathConfig.getPath(PropertyType.CURRENTSTATES, this._clusterName, this._instanceName, this.getSessionId());
        if (!this._zkClient.exists(currentStatePathParent)) {
            this._zkClient.createPersistent(currentStatePathParent);
            logger.info((Object)("Creating current state path " + currentStatePathParent));
        }
    }

    private void startStatusUpdatedumpTask() {
        long initialDelay = 1800000L;
        long period = 0x6DDD00L;
        int timeThresholdNoChange = 10800000;
        if (this._timer == null) {
            this._timer = new Timer(true);
            this._timer.scheduleAtFixedRate((TimerTask)new ZKPathDataDumpTask(this, this._zkClient, timeThresholdNoChange), initialDelay, period);
        }
    }

    private void createClient(String zkServers) throws Exception {
        String propertyStorePath = PropertyPathConfig.getPath(PropertyType.PROPERTYSTORE, this._clusterName, new String[0]);
        ChainedPathZkSerializer zkSerializer = ChainedPathZkSerializer.builder(new ZNRecordStreamingSerializer()).serialize(propertyStorePath, new ByteArraySerializer()).build();
        this._zkClient = new ZkClient(zkServers, this._sessionTimeout, 60000, zkSerializer);
        ZkBaseDataAccessor<ZNRecord> baseDataAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        if (this._instanceType == InstanceType.PARTICIPANT) {
            String curStatePath = PropertyPathConfig.getPath(PropertyType.CURRENTSTATES, this._clusterName, this._instanceName);
            this._baseDataAccessor = new ZkCacheBaseDataAccessor<ZNRecord>(baseDataAccessor, Arrays.asList(curStatePath));
        } else if (this._instanceType == InstanceType.CONTROLLER) {
            String extViewPath = PropertyPathConfig.getPath(PropertyType.EXTERNALVIEW, this._clusterName, new String[0]);
            this._baseDataAccessor = new ZkCacheBaseDataAccessor<ZNRecord>(baseDataAccessor, Arrays.asList(extViewPath));
        } else {
            this._baseDataAccessor = baseDataAccessor;
        }
        this._helixAccessor = new ZKHelixDataAccessor(this._clusterName, this._instanceType, this._baseDataAccessor);
        this._configAccessor = new ConfigAccessor(this._zkClient);
        int retryCount = 0;
        this._zkClient.subscribeStateChanges(this._zkStateChangeListener);
        while (retryCount < 3) {
            try {
                this._zkClient.waitUntilConnected(this._sessionTimeout, TimeUnit.MILLISECONDS);
                this._zkStateChangeListener.handleStateChanged(Watcher.Event.KeeperState.SyncConnected);
                this._zkStateChangeListener.handleNewSession();
                break;
            }
            catch (HelixException e) {
                logger.error((Object)"fail to createClient.", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)("fail to createClient. retry " + ++retryCount), (Throwable)e);
                if (retryCount != 3) continue;
                throw e;
            }
        }
    }

    private CallbackHandler createCallBackHandler(String path, Object listener, Watcher.Event.EventType[] eventTypes, HelixConstants.ChangeType changeType) {
        if (listener == null) {
            throw new HelixException("Listener cannot be null");
        }
        return new CallbackHandler(this, this._zkClient, path, listener, eventTypes, changeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewSession() {
        boolean isConnected = this._zkClient.waitUntilConnected(60000L, TimeUnit.MILLISECONDS);
        while (!isConnected) {
            logger.error((Object)("Could NOT connect to zk server in 60000ms. zkServer: " + this._zkConnectString + ", expiredSessionId: " + this._sessionId + ", clusterName: " + this._clusterName));
            isConnected = this._zkClient.waitUntilConnected(60000L, TimeUnit.MILLISECONDS);
        }
        ZkConnection zkConnection = (ZkConnection)this._zkClient.getConnection();
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            this._sessionId = Long.toHexString(zkConnection.getZookeeper().getSessionId());
        }
        this._baseDataAccessor.reset();
        this.resetHandlers();
        logger.info((Object)("Handling new session, session id:" + this._sessionId + ", instance:" + this._instanceName + ", instanceTye: " + (Object)((Object)this._instanceType) + ", cluster: " + this._clusterName));
        logger.info((Object)zkConnection.getZookeeper());
        if (!ZKUtil.isClusterSetup(this._clusterName, this._zkClient)) {
            throw new HelixException("Initial cluster structure is not set up for cluster:" + this._clusterName);
        }
        if (!this.isInstanceSetup()) {
            throw new HelixException("Initial cluster structure is not set up for instance:" + this._instanceName + " instanceType:" + (Object)((Object)this._instanceType));
        }
        if (this._instanceType == InstanceType.PARTICIPANT || this._instanceType == InstanceType.CONTROLLER_PARTICIPANT) {
            this.handleNewSessionAsParticipant();
        }
        if (this._instanceType == InstanceType.CONTROLLER || this._instanceType == InstanceType.CONTROLLER_PARTICIPANT) {
            this.addControllerMessageListener(this._messagingService.getExecutor());
            DefaultControllerMessageHandlerFactory defaultControllerMsgHandlerFactory = new DefaultControllerMessageHandlerFactory();
            this._messagingService.getExecutor().registerMessageHandlerFactory(defaultControllerMsgHandlerFactory.getMessageType(), defaultControllerMsgHandlerFactory);
            DefaultSchedulerMessageHandlerFactory defaultSchedulerMsgHandlerFactory = new DefaultSchedulerMessageHandlerFactory(this);
            this._messagingService.getExecutor().registerMessageHandlerFactory(defaultSchedulerMsgHandlerFactory.getMessageType(), defaultSchedulerMsgHandlerFactory);
            DefaultParticipantErrorMessageHandlerFactory defaultParticipantErrorMessageHandlerFactory = new DefaultParticipantErrorMessageHandlerFactory(this);
            this._messagingService.getExecutor().registerMessageHandlerFactory(defaultParticipantErrorMessageHandlerFactory.getMessageType(), defaultParticipantErrorMessageHandlerFactory);
            if (this._leaderElectionHandler == null) {
                String path = PropertyPathConfig.getPath(PropertyType.CONTROLLER, this._clusterName, new String[0]);
                this._leaderElectionHandler = this.createCallBackHandler(path, new DistClusterControllerElection(this._zkConnectString), new Watcher.Event.EventType[]{Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.EventType.NodeDeleted, Watcher.Event.EventType.NodeCreated}, HelixConstants.ChangeType.CONTROLLER);
            } else {
                this._leaderElectionHandler.init();
            }
        }
        if (this._instanceType == InstanceType.PARTICIPANT || this._instanceType == InstanceType.CONTROLLER_PARTICIPANT || this._instanceType == InstanceType.CONTROLLER && this.isLeader()) {
            this.initHandlers();
        }
    }

    private void handleNewSessionAsParticipant() {
        String healthCheckInfoPath;
        PropertyKey.Builder keyBuilder = this._helixAccessor.keyBuilder();
        if (this._helixAccessor.getProperty(keyBuilder.liveInstance(this._instanceName)) != null) {
            logger.warn((Object)("Found another instance with same instanceName: " + this._instanceName + " in cluster " + this._clusterName));
            try {
                Thread.sleep(this._sessionTimeout + 5000);
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Sleep interrupted while waiting for previous liveinstance to go away.", (Throwable)e);
            }
            if (this._helixAccessor.getProperty(keyBuilder.liveInstance(this._instanceName)) != null) {
                String errorMessage = "instance " + this._instanceName + " already has a liveinstance in cluster " + this._clusterName;
                logger.error((Object)errorMessage);
                throw new HelixException(errorMessage);
            }
        }
        for (PreConnectCallback callback : this._preConnectCallbacks) {
            callback.onPreConnect();
        }
        this.addLiveInstance();
        this.carryOverPreviousCurrentState();
        this._messagingService.registerMessageHandlerFactory(Message.MessageType.STATE_TRANSITION.toString(), this._stateMachEngine);
        this.addMessageListener(this._messagingService.getExecutor(), this._instanceName);
        this.addControllerListener(this._helixAccessor);
        if (this._participantHealthCheckInfoCollector == null) {
            this._participantHealthCheckInfoCollector = new ParticipantHealthReportCollectorImpl(this, this._instanceName);
            this._participantHealthCheckInfoCollector.start();
        }
        if (!this._zkClient.exists(healthCheckInfoPath = this._helixAccessor.keyBuilder().healthReports(this._instanceName).getPath())) {
            this._zkClient.createPersistent(healthCheckInfoPath, true);
            logger.info((Object)("Creating healthcheck info path " + healthCheckInfoPath));
        }
    }

    @Override
    public void addPreConnectCallback(PreConnectCallback callback) {
        logger.info((Object)"Adding preconnect callback");
        this._preConnectCallbacks.add(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetHandlers() {
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            ArrayList<CallbackHandler> handlers = new ArrayList<CallbackHandler>();
            handlers.addAll(this._handlers);
            for (CallbackHandler handler : handlers) {
                handler.reset();
                logger.info((Object)("reset handler: " + handler.getPath() + " by " + Thread.currentThread().getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHandlers() {
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            ArrayList<CallbackHandler> handlers = new ArrayList<CallbackHandler>();
            handlers.addAll(this._handlers);
            for (CallbackHandler handler : handlers) {
                handler.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addListener(CallbackHandler handler) {
        ZKHelixManager zKHelixManager = this;
        synchronized (zKHelixManager) {
            this._handlers.add(handler);
            logger.info((Object)("add handler: " + handler.getPath() + " by " + Thread.currentThread().getName()));
        }
    }

    @Override
    public boolean isLeader() {
        if (!this.isConnected()) {
            return false;
        }
        if (this._instanceType != InstanceType.CONTROLLER) {
            return false;
        }
        PropertyKey.Builder keyBuilder = this._helixAccessor.keyBuilder();
        LiveInstance leader = (LiveInstance)this._helixAccessor.getProperty(keyBuilder.controllerLeader());
        if (leader == null) {
            return false;
        }
        String leaderName = leader.getInstanceName();
        return leaderName != null && leaderName.equals(this._instanceName);
    }

    private void carryOverPreviousCurrentState() {
        PropertyKey.Builder keyBuilder = this._helixAccessor.keyBuilder();
        List<String> subPaths = this._helixAccessor.getChildNames(keyBuilder.sessions(this._instanceName));
        for (String previousSessionId : subPaths) {
            List previousCurrentStates = this._helixAccessor.getChildValues(keyBuilder.currentStates(this._instanceName, previousSessionId));
            for (CurrentState previousCurrentState : previousCurrentStates) {
                if (previousSessionId.equalsIgnoreCase(this._sessionId)) continue;
                logger.info((Object)("Carrying over old session:" + previousSessionId + " resource " + previousCurrentState.getId() + " to new session:" + this._sessionId));
                String stateModelDefRef = previousCurrentState.getStateModelDefRef();
                if (stateModelDefRef == null) {
                    logger.error((Object)("pervious current state doesn't have a state model def. skip it. prevCS: " + previousCurrentState));
                    continue;
                }
                StateModelDefinition stateModel = (StateModelDefinition)this._helixAccessor.getProperty(keyBuilder.stateModelDef(stateModelDefRef));
                for (String partitionName : previousCurrentState.getPartitionStateMap().keySet()) {
                    previousCurrentState.setState(partitionName, stateModel.getInitialState());
                }
                previousCurrentState.setSessionId(this._sessionId);
                this._helixAccessor.setProperty(keyBuilder.currentState(this._instanceName, this._sessionId, previousCurrentState.getId()), previousCurrentState);
            }
        }
        for (String previousSessionId : subPaths) {
            if (previousSessionId.equalsIgnoreCase(this._sessionId)) continue;
            String path = this._helixAccessor.keyBuilder().currentStates(this._instanceName, previousSessionId).getPath();
            logger.info((Object)("Deleting previous current state. path: " + path + "/" + previousSessionId));
            this._zkClient.deleteRecursive(path);
        }
    }

    @Override
    public synchronized ZkHelixPropertyStore<ZNRecord> getHelixPropertyStore() {
        this.checkConnected();
        if (this._helixPropertyStore == null) {
            String path = PropertyPathConfig.getPath(PropertyType.HELIX_PROPERTYSTORE, this._clusterName, new String[0]);
            this._helixPropertyStore = new ZkHelixPropertyStore(new ZkBaseDataAccessor(this._zkClient), path, null);
        }
        return this._helixPropertyStore;
    }

    @Override
    public synchronized HelixAdmin getClusterManagmentTool() {
        this.checkConnected();
        if (this._zkClient != null) {
            this._managementTool = new ZKHelixAdmin(this._zkClient);
        } else {
            logger.error((Object)"Couldn't get ZKClusterManagementTool because zkClient is null");
        }
        return this._managementTool;
    }

    @Override
    public ClusterMessagingService getMessagingService() {
        return this._messagingService;
    }

    @Override
    public ParticipantHealthReportCollector getHealthReportCollector() {
        this.checkConnected();
        return this._participantHealthCheckInfoCollector;
    }

    @Override
    public InstanceType getInstanceType() {
        return this._instanceType;
    }

    private void checkConnected() {
        if (!this.isConnected()) {
            throw new HelixException("ClusterManager not connected. Call clusterManager.connect()");
        }
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public StateMachineEngine getStateMachineEngine() {
        return this._stateMachEngine;
    }

    protected List<CallbackHandler> getHandlers() {
        return this._handlers;
    }

    @Override
    public void startTimerTasks() {
        for (HelixTimerTask task : this._controllerTimerTasks) {
            task.start();
        }
        this.startStatusUpdatedumpTask();
    }

    @Override
    public void stopTimerTasks() {
        for (HelixTimerTask task : this._controllerTimerTasks) {
            task.stop();
        }
    }
}

