/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.AccessOption;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.manager.zk.Cache;
import org.apache.helix.manager.zk.ZkCacheEventThread;
import org.apache.helix.store.HelixPropertyListener;
import org.apache.helix.store.zk.ZNode;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public class ZkCallbackCache<T>
extends Cache<T>
implements IZkChildListener,
IZkDataListener,
IZkStateListener {
    private static Logger LOG = Logger.getLogger(ZkCallbackCache.class);
    final BaseDataAccessor<T> _accessor;
    final String _chrootPath;
    private final ZkCacheEventThread _eventThread;
    private final Map<String, Set<HelixPropertyListener>> _listener;

    public ZkCallbackCache(BaseDataAccessor<T> accessor, String chrootPath, List<String> paths, ZkCacheEventThread eventThread) {
        this._accessor = accessor;
        this._chrootPath = chrootPath;
        this._listener = new ConcurrentHashMap<String, Set<HelixPropertyListener>>();
        this._eventThread = eventThread;
        if (paths != null && !paths.isEmpty()) {
            for (String path : paths) {
                this.updateRecursive(path);
            }
        }
    }

    @Override
    public void update(String path, T data, Stat stat) {
        String parentPath = new File(path).getParent();
        String childName = new File(path).getName();
        this.addToParentChildSet(parentPath, childName);
        ZNode znode = (ZNode)this._cache.get(path);
        if (znode == null) {
            this._cache.put(path, new ZNode(path, data, stat));
            this.fireEvents(path, Watcher.Event.EventType.NodeCreated);
        } else {
            Stat oldStat = znode.getStat();
            znode.setData(data);
            znode.setStat(stat);
            if (oldStat.getCzxid() != stat.getCzxid()) {
                this.fireEvents(path, Watcher.Event.EventType.NodeDeleted);
                this.fireEvents(path, Watcher.Event.EventType.NodeCreated);
            } else if (oldStat.getVersion() != stat.getVersion()) {
                this.fireEvents(path, Watcher.Event.EventType.NodeDataChanged);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRecursive(String path) {
        if (path == null) {
            return;
        }
        try {
            this._lock.writeLock().lock();
            try {
                this._accessor.subscribeDataChanges(path, this);
                Stat stat = new Stat();
                T readData = this._accessor.get(path, stat, AccessOption.THROW_EXCEPTION_IFNOTEXIST);
                this.update(path, readData, stat);
            }
            catch (ZkNoNodeException e) {
                // empty catch block
            }
            ZNode znode = (ZNode)this._cache.get(path);
            List<String> childNames = this._accessor.subscribeChildChanges(path, this);
            if (childNames != null && !childNames.isEmpty()) {
                for (String childName : childNames) {
                    if (znode.hasChild(childName)) continue;
                    String childPath = path + "/" + childName;
                    znode.addChild(childName);
                    this.updateRecursive(childPath);
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
        if (currentChilds == null) {
            return;
        }
        this.updateRecursive(parentPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDataChange(String dataPath, Object data) throws Exception {
        try {
            this._lock.writeLock().lock();
            Stat stat = new Stat();
            T readData = this._accessor.get(dataPath, stat, AccessOption.THROW_EXCEPTION_IFNOTEXIST);
            ZNode znode = (ZNode)this._cache.get(dataPath);
            if (znode != null) {
                Stat oldStat = znode.getStat();
                znode.setData(readData);
                znode.setStat(stat);
                if (oldStat.getCzxid() != stat.getCzxid()) {
                    this.fireEvents(dataPath, Watcher.Event.EventType.NodeDeleted);
                    this.fireEvents(dataPath, Watcher.Event.EventType.NodeCreated);
                } else if (oldStat.getVersion() != stat.getVersion()) {
                    this.fireEvents(dataPath, Watcher.Event.EventType.NodeDataChanged);
                }
            }
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDataDeleted(String dataPath) throws Exception {
        try {
            this._lock.writeLock().lock();
            this._accessor.unsubscribeDataChanges(dataPath, this);
            this._accessor.unsubscribeChildChanges(dataPath, this);
            String parentPath = new File(dataPath).getParent();
            String name = new File(dataPath).getName();
            this.removeFromParentChildSet(parentPath, name);
            this._cache.remove(dataPath);
            this.fireEvents(dataPath, Watcher.Event.EventType.NodeDeleted);
        }
        finally {
            this._lock.writeLock().unlock();
        }
    }

    public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
    }

    public void handleNewSession() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String path, HelixPropertyListener listener) {
        Map<String, Set<HelixPropertyListener>> map = this._listener;
        synchronized (map) {
            Set<HelixPropertyListener> listeners = this._listener.get(path);
            if (listeners == null) {
                listeners = new CopyOnWriteArraySet<HelixPropertyListener>();
                this._listener.put(path, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String path, HelixPropertyListener childListener) {
        Map<String, Set<HelixPropertyListener>> map = this._listener;
        synchronized (map) {
            Set<HelixPropertyListener> listeners = this._listener.get(path);
            if (listeners != null) {
                listeners.remove(childListener);
            }
        }
    }

    private void fireEvents(String path, Watcher.Event.EventType type) {
        String clientPath;
        String tmpPath = path;
        String string = this._chrootPath == null ? path : (clientPath = this._chrootPath.equals(path) ? "/" : path.substring(this._chrootPath.length()));
        while (tmpPath != null) {
            Set<HelixPropertyListener> listeners = this._listener.get(tmpPath);
            if (listeners != null && !listeners.isEmpty()) {
                for (final HelixPropertyListener listener : listeners) {
                    try {
                        switch (type) {
                            case NodeDataChanged: {
                                this._eventThread.send(new ZkCacheEventThread.ZkCacheEvent("dataChange on " + path + " send to " + listener){

                                    @Override
                                    public void run() throws Exception {
                                        listener.onDataChange(clientPath);
                                    }
                                });
                                break;
                            }
                            case NodeCreated: {
                                this._eventThread.send(new ZkCacheEventThread.ZkCacheEvent("dataCreate on " + path + " send to " + listener){

                                    @Override
                                    public void run() throws Exception {
                                        listener.onDataCreate(clientPath);
                                    }
                                });
                                break;
                            }
                            case NodeDeleted: {
                                this._eventThread.send(new ZkCacheEventThread.ZkCacheEvent("dataDelete on " + path + " send to " + listener){

                                    @Override
                                    public void run() throws Exception {
                                        listener.onDataDelete(clientPath);
                                    }
                                });
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception in handle events.", (Throwable)e);
                    }
                }
            }
            tmpPath = new File(tmpPath).getParent();
        }
    }
}

