/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.serialize.SerializableSerializer;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.helix.manager.zk.BasicZkSerializer;
import org.apache.helix.manager.zk.ByteArraySerializer;
import org.apache.helix.manager.zk.PathBasedZkSerializer;
import org.apache.helix.manager.zk.ZkAsyncCallbacks;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ZkClient
extends org.I0Itec.zkclient.ZkClient {
    private static Logger LOG = Logger.getLogger(ZkClient.class);
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_SESSION_TIMEOUT = 30000;
    private PathBasedZkSerializer _zkSerializer;

    public ZkClient(IZkConnection connection, int connectionTimeout, PathBasedZkSerializer zkSerializer) {
        super(connection, connectionTimeout, (ZkSerializer)new ByteArraySerializer());
        this._zkSerializer = zkSerializer;
        if (LOG.isTraceEnabled()) {
            StackTraceElement[] calls = Thread.currentThread().getStackTrace();
            LOG.info((Object)("create a new zkclient. " + Arrays.asList(calls)));
        }
    }

    public ZkClient(IZkConnection connection, int connectionTimeout, ZkSerializer zkSerializer) {
        this(connection, connectionTimeout, new BasicZkSerializer(zkSerializer));
    }

    public ZkClient(IZkConnection connection, int connectionTimeout) {
        this(connection, connectionTimeout, (ZkSerializer)new SerializableSerializer());
    }

    public ZkClient(IZkConnection connection) {
        this(connection, Integer.MAX_VALUE, (ZkSerializer)new SerializableSerializer());
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout, ZkSerializer zkSerializer) {
        this((IZkConnection)new ZkConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout, PathBasedZkSerializer zkSerializer) {
        this((IZkConnection)new ZkConnection(zkServers, sessionTimeout), connectionTimeout, zkSerializer);
    }

    public ZkClient(String zkServers, int sessionTimeout, int connectionTimeout) {
        this((IZkConnection)new ZkConnection(zkServers, sessionTimeout), connectionTimeout, (ZkSerializer)new SerializableSerializer());
    }

    public ZkClient(String zkServers, int connectionTimeout) {
        this((IZkConnection)new ZkConnection(zkServers), connectionTimeout, (ZkSerializer)new SerializableSerializer());
    }

    public ZkClient(String zkServers) {
        this((IZkConnection)new ZkConnection(zkServers), Integer.MAX_VALUE, (ZkSerializer)new SerializableSerializer());
    }

    public void setZkSerializer(ZkSerializer zkSerializer) {
        this._zkSerializer = new BasicZkSerializer(zkSerializer);
    }

    public void setZkSerializer(PathBasedZkSerializer zkSerializer) {
        this._zkSerializer = zkSerializer;
    }

    public IZkConnection getConnection() {
        return this._connection;
    }

    public void close() throws ZkInterruptedException {
        if (LOG.isTraceEnabled()) {
            StackTraceElement[] calls = Thread.currentThread().getStackTrace();
            LOG.trace((Object)("closing a zkclient. zookeeper: " + (this._connection == null ? "null" : ((ZkConnection)this._connection).getZookeeper()) + ", callStack: " + Arrays.asList(calls)));
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat getStat(final String path) {
        long startT = System.nanoTime();
        try {
            Stat stat;
            Stat stat2 = stat = (Stat)this.retryUntilConnected(new Callable<Stat>(){

                @Override
                public Stat call() throws Exception {
                    Stat stat = ((ZkConnection)ZkClient.this._connection).getZookeeper().exists(path, false);
                    return stat;
                }
            });
            return stat2;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("exists, path: " + path + ", time: " + (endT - startT) + " ns"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(final String path, final boolean watch) {
        long startT = System.nanoTime();
        try {
            boolean bl = (Boolean)this.retryUntilConnected(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return ZkClient.this._connection.exists(path, watch);
                }
            });
            return bl;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("exists, path: " + path + ", time: " + (endT - startT) + " ns"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getChildren(final String path, final boolean watch) {
        long startT = System.nanoTime();
        try {
            List list = (List)this.retryUntilConnected(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return ZkClient.this._connection.getChildren(path, watch);
                }
            });
            return list;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("getChildren, path: " + path + ", time: " + (endT - startT) + " ns"));
            }
        }
    }

    public <T> T deserialize(byte[] data, String path) {
        if (data == null) {
            return null;
        }
        return (T)this._zkSerializer.deserialize(data, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T readData(final String path, final Stat stat, final boolean watch) {
        long startT = System.nanoTime();
        try {
            byte[] data = (byte[])this.retryUntilConnected(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    return ZkClient.this._connection.readData(path, stat, watch);
                }
            });
            T t = this.deserialize(data, path);
            return t;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("getData, path: " + path + ", time: " + (endT - startT) + " ns"));
            }
        }
    }

    public <T> T readDataAndStat(String path, Stat stat, boolean returnNullIfPathNotExists) {
        Object data;
        block2: {
            data = null;
            try {
                data = super.readData(path, stat);
            }
            catch (ZkNoNodeException e) {
                if (returnNullIfPathNotExists) break block2;
                throw e;
            }
        }
        return (T)data;
    }

    public String getServers() {
        return this._connection.getServers();
    }

    public byte[] serialize(Object data, String path) {
        return this._zkSerializer.serialize(data, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData(final String path, Object datat, final int expectedVersion) {
        long startT = System.nanoTime();
        try {
            final byte[] data = this.serialize(datat, path);
            this.retryUntilConnected(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ZkClient.this._connection.writeData(path, data, expectedVersion);
                    return null;
                }
            });
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("setData, path: " + path + ", time: " + (endT - startT) + " ns"));
            }
        }
    }

    public Stat writeDataGetStat(String path, Object datat, int expectedVersion) throws InterruptedException {
        Stat stat = null;
        long start = System.nanoTime();
        try {
            byte[] bytes = this._zkSerializer.serialize(datat, path);
            Stat stat2 = stat = ((ZkConnection)this._connection).getZookeeper().setData(path, bytes, expectedVersion);
            return stat2;
        }
        catch (KeeperException e) {
            throw ZkException.create((KeeperException)e);
        }
        finally {
            long end = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("setData, path: " + path + ", time: " + (end - start) + " ns"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(final String path, Object data, final CreateMode mode) throws ZkInterruptedException, IllegalArgumentException, ZkException, RuntimeException {
        if (path == null) {
            throw new NullPointerException("path must not be null.");
        }
        long startT = System.nanoTime();
        try {
            final byte[] bytes = data == null ? null : this.serialize(data, path);
            String string = (String)this.retryUntilConnected(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ZkClient.this._connection.create(path, bytes, mode);
                }
            });
            return string;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("create, path: " + path + ", time: " + (endT - startT) + " ns"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(final String path) {
        long startT = System.nanoTime();
        try {
            this.retryUntilConnected(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ZkClient.this._connection.delete(path);
                    return null;
                }
            });
            boolean bl = true;
            return bl;
        }
        catch (ZkNoNodeException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            long endT = System.nanoTime();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("delete, path: " + path + ", time: " + (endT - startT) + " ns"));
            }
        }
    }

    public void asyncCreate(String path, Object datat, CreateMode mode, ZkAsyncCallbacks.CreateCallbackHandler cb) {
        byte[] data = null;
        if (datat != null) {
            data = this.serialize(datat, path);
        }
        ((ZkConnection)this._connection).getZookeeper().create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode, (AsyncCallback.StringCallback)cb, null);
    }

    public void asyncSetData(String path, Object datat, int version, ZkAsyncCallbacks.SetDataCallbackHandler cb) {
        byte[] data = this.serialize(datat, path);
        ((ZkConnection)this._connection).getZookeeper().setData(path, data, version, (AsyncCallback.StatCallback)cb, null);
    }

    public void asyncGetData(String path, ZkAsyncCallbacks.GetDataCallbackHandler cb) {
        ((ZkConnection)this._connection).getZookeeper().getData(path, null, (AsyncCallback.DataCallback)cb, null);
    }

    public void asyncExists(String path, ZkAsyncCallbacks.ExistsCallbackHandler cb) {
        ((ZkConnection)this._connection).getZookeeper().exists(path, null, (AsyncCallback.StatCallback)cb, null);
    }

    public void asyncDelete(String path, ZkAsyncCallbacks.DeleteCallbackHandler cb) {
        ((ZkConnection)this._connection).getZookeeper().delete(path, -1, (AsyncCallback.VoidCallback)cb, null);
    }
}

