/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkConnection;
import org.apache.helix.manager.zk.ZKHelixManager;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class ZkStateChangeListener
implements IZkStateListener {
    private volatile boolean _isConnected;
    private volatile boolean _hasSessionExpired;
    private final ZKHelixManager _zkHelixManager;
    private static Logger logger = Logger.getLogger(ZkStateChangeListener.class);

    public ZkStateChangeListener(ZKHelixManager zkHelixManager) {
        this._zkHelixManager = zkHelixManager;
    }

    public void handleNewSession() {
        this._isConnected = true;
        this._hasSessionExpired = false;
        this._zkHelixManager.handleNewSession();
    }

    public void handleStateChanged(Watcher.Event.KeeperState keeperState) throws Exception {
        switch (keeperState) {
            case SyncConnected: {
                ZkConnection zkConnection = (ZkConnection)this._zkHelixManager._zkClient.getConnection();
                logger.info((Object)("KeeperState: " + keeperState + ", zookeeper:" + zkConnection.getZookeeper()));
                this._isConnected = true;
                break;
            }
            case Disconnected: {
                logger.info((Object)("KeeperState:" + keeperState + ", disconnectedSessionId: " + this._zkHelixManager._sessionId + ", instance: " + this._zkHelixManager.getInstanceName() + ", type: " + (Object)((Object)this._zkHelixManager.getInstanceType())));
                this._isConnected = false;
                break;
            }
            case Expired: {
                logger.info((Object)("KeeperState:" + keeperState + ", expiredSessionId: " + this._zkHelixManager._sessionId + ", instance: " + this._zkHelixManager.getInstanceName() + ", type: " + (Object)((Object)this._zkHelixManager.getInstanceType())));
                this._isConnected = false;
                this._hasSessionExpired = true;
            }
        }
    }

    boolean isConnected() {
        return this._isConnected;
    }

    void disconnect() {
        this._isConnected = false;
    }

    boolean hasSessionExpired() {
        return this._hasSessionExpired;
    }
}

