/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecordBucketizer;
import org.apache.helix.ZNRecordDelta;
import org.apache.helix.messaging.handling.HelixTaskExecutor;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelParser;
import org.apache.helix.participant.statemachine.StateTransitionError;
import org.apache.helix.util.StatusUpdateUtil;
import org.apache.log4j.Logger;

public class HelixStateTransitionHandler
extends MessageHandler {
    private static Logger logger = Logger.getLogger(HelixStateTransitionHandler.class);
    private final StateModel _stateModel;
    StatusUpdateUtil _statusUpdateUtil;
    private final StateModelParser _transitionMethodFinder;
    private final CurrentState _currentStateDelta;
    volatile boolean _isTimeout = false;
    private final HelixTaskExecutor _executor;

    public HelixStateTransitionHandler(StateModel stateModel, Message message, NotificationContext context, CurrentState currentStateDelta, HelixTaskExecutor executor) {
        super(message, context);
        this._stateModel = stateModel;
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._transitionMethodFinder = new StateModelParser();
        this._currentStateDelta = currentStateDelta;
        this._executor = executor;
    }

    private void prepareMessageExecution(HelixManager manager, Message message) throws HelixException, HelixStateMismatchException {
        if (!message.isValid()) {
            String errorMessage = "Invalid Message, ensure that message: " + message + " has all the required fields: " + Arrays.toString((Object[])Message.Attributes.values());
            this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, errorMessage, manager.getHelixDataAccessor());
            logger.error((Object)errorMessage);
            throw new HelixException(errorMessage);
        }
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        String partitionName = message.getPartitionName();
        String fromState = message.getFromState();
        String state = this._currentStateDelta.getState(partitionName);
        if (fromState != null && !fromState.equals("*") && !fromState.equalsIgnoreCase(state)) {
            String errorMessage = "Current state of stateModel does not match the fromState in Message, Current State:" + state + ", message expected:" + fromState + ", partition: " + partitionName + ", from: " + message.getMsgSrc() + ", to: " + message.getTgtName();
            this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, errorMessage, accessor);
            logger.error((Object)errorMessage);
            throw new HelixStateMismatchException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postExecutionMessage(HelixManager manager, Message message, NotificationContext context, HelixTaskResult taskResult, Exception exception) {
        StateTransitionError error;
        String partitionKey = message.getPartitionName();
        String resource = message.getResourceName();
        String sessionId = message.getTgtSessionId();
        String instanceName = manager.getInstanceName();
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        int bucketSize = message.getBucketSize();
        ZNRecordBucketizer bucketizer = new ZNRecordBucketizer(bucketSize);
        HelixManager helixManager = manager;
        synchronized (helixManager) {
            if (!message.getTgtSessionId().equals(manager.getSessionId())) {
                logger.warn((Object)("Session id has changed. Skip postExecutionMessage. Old session " + message.getExecutionSessionId() + " , new session : " + manager.getSessionId()));
                return;
            }
            if (taskResult.isSucess()) {
                String toState = message.getToState();
                this._currentStateDelta.setState(partitionKey, toState);
                if (toState.equalsIgnoreCase("DROPPED")) {
                    ZNRecordDelta delta = new ZNRecordDelta(this._currentStateDelta.getRecord(), ZNRecordDelta.MergeOperation.SUBTRACT);
                    delta._record.getSimpleFields().clear();
                    ArrayList<ZNRecordDelta> deltaList = new ArrayList<ZNRecordDelta>();
                    deltaList.add(delta);
                    this._currentStateDelta.setDeltaList(deltaList);
                } else {
                    this._stateModel.updateState(toState);
                }
            } else if (exception instanceof HelixStateMismatchException) {
                logger.warn((Object)("Force CurrentState on Zk to be stateModel's CurrentState. partitionKey: " + partitionKey + ", currentState: " + this._stateModel.getCurrentState() + ", message: " + message));
                this._currentStateDelta.setState(partitionKey, this._stateModel.getCurrentState());
            } else {
                error = new StateTransitionError(MessageHandler.ErrorType.INTERNAL, MessageHandler.ErrorCode.ERROR, exception);
                if (exception instanceof InterruptedException) {
                    if (this._isTimeout) {
                        error = new StateTransitionError(MessageHandler.ErrorType.INTERNAL, MessageHandler.ErrorCode.TIMEOUT, exception);
                    } else {
                        logger.error((Object)("State transition interrupted but not timeout. Not updating state. Partition : " + message.getPartitionName() + " MsgId : " + message.getMsgId()));
                        return;
                    }
                }
                this._stateModel.rollbackOnError(message, context, error);
                this._currentStateDelta.setState(partitionKey, "ERROR");
                this._stateModel.updateState("ERROR");
            }
        }
        try {
            PropertyKey key = keyBuilder.currentState(instanceName, sessionId, resource, bucketizer.getBucketName(partitionKey));
            if (!this._message.getGroupMessageMode()) {
                accessor.updateProperty(key, this._currentStateDelta);
            } else {
                this._executor._groupMsgHandler.addCurStateUpdate(this._message, key, this._currentStateDelta);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error when updating the state ", (Throwable)e);
            error = new StateTransitionError(MessageHandler.ErrorType.FRAMEWORK, MessageHandler.ErrorCode.ERROR, e);
            this._stateModel.rollbackOnError(message, context, error);
            this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, e, "Error when update the state ", accessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HelixTaskResult handleMessageInternal(Message message, NotificationContext context) {
        StateModel stateModel = this._stateModel;
        synchronized (stateModel) {
            HelixTaskResult taskResult = new HelixTaskResult();
            HelixManager manager = context.getManager();
            HelixDataAccessor accessor = manager.getHelixDataAccessor();
            this._statusUpdateUtil.logInfo(message, HelixStateTransitionHandler.class, "Message handling task begin execute", accessor);
            message.setExecuteStartTimeStamp(new Date().getTime());
            Exception exception = null;
            try {
                this.prepareMessageExecution(manager, message);
                this.invoke(accessor, context, taskResult, message);
            }
            catch (HelixStateMismatchException e) {
                taskResult.setSuccess(false);
                taskResult.setMessage(e.toString());
                taskResult.setException(e);
                exception = e;
            }
            catch (Exception e2) {
                InterruptedException e2;
                String errorMessage = "Exception while executing a state transition task " + message.getPartitionName();
                logger.error((Object)errorMessage, (Throwable)e2);
                if (e2.getCause() != null && e2.getCause() instanceof InterruptedException) {
                    e2 = (InterruptedException)e2.getCause();
                }
                this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, e2, errorMessage, accessor);
                taskResult.setSuccess(false);
                taskResult.setMessage(e2.toString());
                taskResult.setException(e2);
                taskResult.setInterrupted(e2 instanceof InterruptedException);
                exception = e2;
            }
            this.postExecutionMessage(manager, message, context, taskResult, exception);
            return taskResult;
        }
    }

    private void invoke(HelixDataAccessor accessor, NotificationContext context, HelixTaskResult taskResult, Message message) throws IllegalAccessException, InvocationTargetException, InterruptedException {
        this._statusUpdateUtil.logInfo(message, HelixStateTransitionHandler.class, "Message handling invoking", accessor);
        Method methodToInvoke = null;
        String fromState = message.getFromState();
        String toState = message.getToState();
        methodToInvoke = this._transitionMethodFinder.getMethodForTransition(this._stateModel.getClass(), fromState, toState, new Class[]{Message.class, NotificationContext.class});
        if (methodToInvoke != null) {
            methodToInvoke.invoke((Object)this._stateModel, message, context);
            taskResult.setSuccess(true);
        } else {
            String errorMessage = "Unable to find method for transition from " + fromState + " to " + toState + "in " + this._stateModel.getClass();
            logger.error((Object)errorMessage);
            taskResult.setSuccess(false);
            this._statusUpdateUtil.logError(message, HelixStateTransitionHandler.class, errorMessage, accessor);
        }
    }

    @Override
    public HelixTaskResult handleMessage() {
        return this.handleMessageInternal(this._message, this._notificationContext);
    }

    @Override
    public void onError(Exception e, MessageHandler.ErrorCode code, MessageHandler.ErrorType type) {
        if (type == MessageHandler.ErrorType.INTERNAL) {
            logger.error((Object)("Skip internal error " + e.getMessage() + " " + (Object)((Object)code)));
            return;
        }
        HelixManager manager = this._notificationContext.getManager();
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String instanceName = manager.getInstanceName();
        String partition = this._message.getPartitionName();
        String resourceName = this._message.getResourceName();
        CurrentState currentStateDelta = new CurrentState(resourceName);
        StateTransitionError error = new StateTransitionError(type, code, e);
        this._stateModel.rollbackOnError(this._message, this._notificationContext, error);
        if (code == MessageHandler.ErrorCode.ERROR) {
            currentStateDelta.setState(partition, "ERROR");
            this._stateModel.updateState("ERROR");
            accessor.updateProperty(keyBuilder.currentState(instanceName, this._message.getTgtSessionId(), resourceName), currentStateDelta);
        }
    }

    @Override
    public void onTimeout() {
        this._isTimeout = true;
    }

    public static class HelixStateMismatchException
    extends Exception {
        public HelixStateMismatchException(String info) {
            super(info);
        }
    }
}

