/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.Message;
import org.apache.log4j.Logger;

public class ClusterConstraints
extends HelixProperty {
    private static Logger LOG = Logger.getLogger(ClusterConstraints.class);
    private final List<ConstraintItem> _constraints = new ArrayList<ConstraintItem>();

    public ClusterConstraints(ZNRecord record) {
        super(record);
        for (String key : this._record.getMapFields().keySet()) {
            ConstraintItem item = new ConstraintItem(this._record.getMapField(key));
            if (item.getAttributes().size() > 0 && item.getConstraintValue() != null) {
                this._constraints.add(item);
                continue;
            }
            LOG.error((Object)("Invalid constraint " + key + ":" + this._record.getMapField(key)));
        }
    }

    public Set<ConstraintItem> match(Map<ConstraintAttribute, String> attributes) {
        HashSet<ConstraintItem> matches = new HashSet<ConstraintItem>();
        for (ConstraintItem item : this._constraints) {
            if (!item.match(attributes)) continue;
            matches.add(item);
        }
        return matches;
    }

    public static Map<ConstraintAttribute, String> toConstraintAttributes(Message msg) {
        TreeMap<ConstraintAttribute, String> attributes = new TreeMap<ConstraintAttribute, String>();
        String msgType = msg.getMsgType();
        attributes.put(ConstraintAttribute.MESSAGE_TYPE, msgType);
        if (Message.MessageType.STATE_TRANSITION.toString().equals(msgType)) {
            if (msg.getFromState() != null && msg.getToState() != null) {
                attributes.put(ConstraintAttribute.TRANSITION, msg.getFromState() + "-" + msg.getToState());
            }
            if (msg.getResourceName() != null) {
                attributes.put(ConstraintAttribute.RESOURCE, msg.getResourceName());
            }
            if (msg.getTgtName() != null) {
                attributes.put(ConstraintAttribute.INSTANCE, msg.getTgtName());
            }
        }
        return attributes;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static class ConstraintItem {
        final Map<ConstraintAttribute, String> _attributes = new TreeMap<ConstraintAttribute, String>();
        String _constraintValue = null;

        public ConstraintItem(Map<String, String> attributes) {
            if (attributes != null) {
                for (String key : attributes.keySet()) {
                    try {
                        ConstraintAttribute attr = ConstraintAttribute.valueOf(key);
                        if (attr == ConstraintAttribute.CONSTRAINT_VALUE) {
                            String value = attributes.get(key);
                            try {
                                ConstraintValue.valueOf(value);
                            }
                            catch (Exception e) {
                                try {
                                    Integer.parseInt(value);
                                }
                                catch (NumberFormatException ne) {
                                    LOG.error((Object)("Invalid constraintValue " + key + ":" + value));
                                    continue;
                                }
                            }
                            this._constraintValue = attributes.get(key);
                            continue;
                        }
                        this._attributes.put(attr, attributes.get(key));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Invalid constraintAttribute " + key + ":" + attributes.get(key)));
                    }
                }
            }
        }

        public boolean match(Map<ConstraintAttribute, String> attributes) {
            for (ConstraintAttribute key : this._attributes.keySet()) {
                if (!attributes.containsKey((Object)key)) {
                    return false;
                }
                if (attributes.get((Object)key).matches(this._attributes.get((Object)key))) continue;
                return false;
            }
            return true;
        }

        public Map<ConstraintAttribute, String> filter(Map<ConstraintAttribute, String> attributes) {
            HashMap<ConstraintAttribute, String> ret = new HashMap<ConstraintAttribute, String>();
            for (ConstraintAttribute key : this._attributes.keySet()) {
                ret.put(key, attributes.get((Object)key));
            }
            return ret;
        }

        public String getConstraintValue() {
            return this._constraintValue;
        }

        public Map<ConstraintAttribute, String> getAttributes() {
            return this._attributes;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._attributes + ":" + this._constraintValue);
            return sb.toString();
        }
    }

    public static enum ConstraintType {
        STATE_CONSTRAINT,
        MESSAGE_CONSTRAINT;

    }

    public static enum ConstraintValue {
        ANY;

    }

    public static enum ConstraintAttribute {
        STATE,
        MESSAGE_TYPE,
        TRANSITION,
        RESOURCE,
        INSTANCE,
        CONSTRAINT_VALUE;

    }
}

