/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

public class InstanceConfig
extends HelixProperty {
    private static final Logger _logger = Logger.getLogger((String)InstanceConfig.class.getName());

    public InstanceConfig(String id) {
        super(id);
    }

    public InstanceConfig(ZNRecord record) {
        super(record);
    }

    public String getHostName() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_HOST.toString());
    }

    public void setHostName(String hostName) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_HOST.toString(), hostName);
    }

    public String getPort() {
        return this._record.getSimpleField(InstanceConfigProperty.HELIX_PORT.toString());
    }

    public void setPort(String port) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_PORT.toString(), port);
    }

    public boolean getInstanceEnabled() {
        String isEnabled = this._record.getSimpleField(InstanceConfigProperty.HELIX_ENABLED.toString());
        return isEnabled == null || Boolean.parseBoolean(isEnabled);
    }

    public void setInstanceEnabled(boolean enabled) {
        this._record.setSimpleField(InstanceConfigProperty.HELIX_ENABLED.toString(), Boolean.toString(enabled));
    }

    public boolean getInstanceEnabledForPartition(String partition) {
        List<String> disabledPartitions = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
        return disabledPartitions == null || !disabledPartitions.contains(partition);
    }

    public Map<String, String> getDisabledPartitionMap() {
        return this._record.getMapField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
    }

    public void setInstanceEnabledForPartition(String partitionName, boolean enabled) {
        List<String> list = this._record.getListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
        HashSet<String> disabledPartitions = new HashSet<String>();
        if (list != null) {
            disabledPartitions.addAll(list);
        }
        if (enabled) {
            disabledPartitions.remove(partitionName);
        } else {
            disabledPartitions.add(partitionName);
        }
        list = new ArrayList<String>(disabledPartitions);
        Collections.sort(list);
        this._record.setListField(InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString(), list);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof InstanceConfig) {
            InstanceConfig that = (InstanceConfig)obj;
            if (this.getHostName().equals(that.getHostName()) && this.getPort().equals(that.getPort())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getHostName());
        sb.append("_");
        sb.append(this.getPort());
        return sb.toString().hashCode();
    }

    public String getInstanceName() {
        return this._record.getId();
    }

    @Override
    public boolean isValid() {
        if (this.getHostName() == null) {
            _logger.error((Object)("instanceconfig does not have host name. id:" + this._record.getId()));
            return false;
        }
        if (this.getPort() == null) {
            _logger.error((Object)("instanceconfig does not have host port. id:" + this._record.getId()));
            return false;
        }
        return true;
    }

    public static enum InstanceConfigProperty {
        HELIX_HOST,
        HELIX_PORT,
        HELIX_ENABLED,
        HELIX_DISABLED_PARTITION;

    }
}

