/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.Transition;
import org.apache.helix.participant.statemachine.StateTransitionTableBuilder;
import org.apache.log4j.Logger;

public class StateModelDefinition
extends HelixProperty {
    private static final Logger _logger = Logger.getLogger((String)StateModelDefinition.class.getName());
    private final List<String> _statesPriorityList;
    private final Map<String, String> _statesCountMap;
    private final List<String> _stateTransitionPriorityList;
    private final Map<String, Map<String, String>> _stateTransitionTable;

    public StateModelDefinition(ZNRecord record) {
        super(record);
        this._statesPriorityList = record.getListField(StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString());
        this._stateTransitionPriorityList = record.getListField(StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString());
        this._stateTransitionTable = new HashMap<String, Map<String, String>>();
        this._statesCountMap = new HashMap<String, String>();
        if (this._statesPriorityList != null) {
            for (String state : this._statesPriorityList) {
                Map<String, String> metaData = record.getMapField(state + ".meta");
                if (metaData != null && metaData.get("count") != null) {
                    this._statesCountMap.put(state, metaData.get("count"));
                }
                Map<String, String> nextData = record.getMapField(state + ".next");
                this._stateTransitionTable.put(state, nextData);
            }
        }
    }

    public List<String> getStateTransitionPriorityList() {
        return this._stateTransitionPriorityList;
    }

    public List<String> getStatesPriorityList() {
        return this._statesPriorityList;
    }

    public String getNextStateForTransition(String fromState, String toState) {
        Map<String, String> map = this._stateTransitionTable.get(fromState);
        if (map != null) {
            return map.get(toState);
        }
        return null;
    }

    public String getInitialState() {
        return this._record.getSimpleField(StateModelDefinitionProperty.INITIAL_STATE.toString());
    }

    public String getNumInstancesPerState(String state) {
        return this._statesCountMap.get(state);
    }

    @Override
    public boolean isValid() {
        if (this.getInitialState() == null) {
            _logger.error((Object)("State model does not contain init state, statemodel:" + this._record.getId()));
            return false;
        }
        if (this._record.getListField(StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString()) == null) {
            _logger.error((Object)("CurrentState does not contain StatesPriorityList, state model : " + this._record.getId()));
            return false;
        }
        return true;
    }

    public static class Builder {
        private final String _statemodelName;
        private String initialState;
        Map<String, Integer> statesMap;
        Map<Transition, Integer> transitionMap;
        Map<String, String> stateConstraintMap;

        public Builder(String name) {
            this._statemodelName = name;
            this.statesMap = new HashMap<String, Integer>();
            this.transitionMap = new HashMap<Transition, Integer>();
            this.stateConstraintMap = new HashMap<String, String>();
        }

        public Builder initialState(String initialState) {
            this.initialState = initialState;
            return this;
        }

        public Builder addState(String state, int priority) {
            this.statesMap.put(state, priority);
            return this;
        }

        public Builder addState(String state) {
            this.addState(state, Integer.MAX_VALUE);
            return this;
        }

        public Builder addTransition(String fromState, String toState, int priority) {
            this.transitionMap.put(new Transition(fromState, toState), priority);
            return this;
        }

        public Builder addTransition(String fromState, String toState) {
            this.addTransition(fromState, toState, Integer.MAX_VALUE);
            return this;
        }

        public Builder upperBound(String state, int upperBound) {
            this.stateConstraintMap.put(state, String.valueOf(upperBound));
            return this;
        }

        public Builder dynamicUpperBound(String state, String bound) {
            this.stateConstraintMap.put(state, bound);
            return this;
        }

        public StateModelDefinition build() {
            ZNRecord record = new ZNRecord(this._statemodelName);
            ArrayList<String> statePriorityList = new ArrayList<String>(this.statesMap.keySet());
            Comparator<String> c1 = new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return Builder.this.statesMap.get(o1).compareTo(Builder.this.statesMap.get(o2));
                }
            };
            Collections.sort(statePriorityList, c1);
            ArrayList<Transition> transitionList = new ArrayList<Transition>(this.transitionMap.keySet());
            Comparator<Transition> c2 = new Comparator<Transition>(){

                @Override
                public int compare(Transition o1, Transition o2) {
                    return Builder.this.transitionMap.get(o1).compareTo(Builder.this.transitionMap.get(o2));
                }
            };
            Collections.sort(transitionList, c2);
            ArrayList<String> transitionPriorityList = new ArrayList<String>(transitionList.size());
            for (Transition t : transitionList) {
                transitionPriorityList.add(t.toString());
            }
            record.setSimpleField(StateModelDefinitionProperty.INITIAL_STATE.toString(), this.initialState);
            record.setListField(StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
            record.setListField(StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), transitionPriorityList);
            StateTransitionTableBuilder stateTransitionTableBuilder = new StateTransitionTableBuilder();
            Map<String, Map<String, String>> transitionTable = stateTransitionTableBuilder.buildTransitionTable(statePriorityList, new ArrayList<Transition>(this.transitionMap.keySet()));
            for (String state : transitionTable.keySet()) {
                record.setMapField(state + ".next", transitionTable.get(state));
            }
            for (String state : statePriorityList) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                if (this.stateConstraintMap.get(state) != null) {
                    metadata.put("count", this.stateConstraintMap.get(state));
                } else {
                    metadata.put("count", "-1");
                }
                record.setMapField(state + ".meta", metadata);
            }
            return new StateModelDefinition(record);
        }
    }

    public static enum StateModelDefinitionProperty {
        INITIAL_STATE,
        STATE_TRANSITION_PRIORITYLIST,
        STATE_PRIORITY_LIST;

    }
}

