/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring.mbeans;

import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.alerts.AlertParser;
import org.apache.helix.alerts.AlertValueAndStatus;
import org.apache.helix.alerts.Tuple;
import org.apache.helix.monitoring.mbeans.ClusterAlertItem;
import org.apache.helix.monitoring.mbeans.ClusterAlertItemMBean;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class ClusterAlertMBeanCollection {
    public static String DOMAIN_ALERT = "HelixAlerts";
    public static String ALERT_SUMMARY = "AlertSummary";
    private static final Logger _logger = Logger.getLogger(ClusterAlertMBeanCollection.class);
    ConcurrentHashMap<String, ClusterAlertItem> _alertBeans = new ConcurrentHashMap();
    Map<String, String> _recentAlertDelta;
    ClusterAlertSummary _clusterAlertSummary;
    ZNRecord _alertHistory = new ZNRecord(PropertyType.ALERT_HISTORY.toString());
    Set<String> _previousFiredAlerts = new HashSet<String>();
    public static final long ALERT_NOCHANGE_THRESHOLD = 300000L;
    final MBeanServer _beanServer = ManagementFactory.getPlatformMBeanServer();

    public Collection<ClusterAlertItemMBean> getCurrentAlertMBeans() {
        ArrayList<ClusterAlertItemMBean> beans = new ArrayList<ClusterAlertItemMBean>();
        for (ClusterAlertItem item : this._alertBeans.values()) {
            beans.add(item);
        }
        return beans;
    }

    void onNewAlertMbeanAdded(ClusterAlertItemMBean bean) {
        try {
            _logger.info((Object)("alert bean " + bean.getSensorName() + " exposed to jmx"));
            System.out.println("alert bean " + bean.getSensorName() + " exposed to jmx");
            ObjectName objectName = new ObjectName(DOMAIN_ALERT + ":alert=" + bean.getSensorName());
            this.register(bean, objectName);
        }
        catch (Exception e) {
            _logger.error((Object)"", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void setAlerts(String originAlert, Map<String, AlertValueAndStatus> alertResultMap, String clusterName) {
        if (alertResultMap == null) {
            _logger.warn((Object)"null alertResultMap");
            return;
        }
        for (String alertName : alertResultMap.keySet()) {
            String beanName = "";
            if (alertName.length() > 1) {
                String comparator = AlertParser.getComponent("CMP", originAlert);
                String constant = AlertParser.getComponent("CON", originAlert);
                beanName = "(" + alertName + ")" + comparator + "(" + constant + ")";
            } else {
                beanName = originAlert + "--(" + alertName + ")";
            }
            beanName = beanName.replace('*', '%').replace('=', '#').replace(',', ';');
            if (!this._alertBeans.containsKey(beanName)) {
                ClusterAlertItem item = new ClusterAlertItem(beanName, alertResultMap.get(alertName));
                this.onNewAlertMbeanAdded(item);
                this._alertBeans.put(beanName, item);
                continue;
            }
            this._alertBeans.get(beanName).setValueMap(alertResultMap.get(alertName));
        }
        this.refreshSummayAlert(clusterName);
    }

    public void setAlertHistory(ZNRecord alertHistory) {
        this._alertHistory = alertHistory;
    }

    void refreshSummayAlert(String clusterName) {
        ClusterAlertItem item;
        boolean fired = false;
        String alertsFired = "";
        String summaryKey = ALERT_SUMMARY + "_" + clusterName;
        for (String key : this._alertBeans.keySet()) {
            if (key.equals(summaryKey)) continue;
            item = this._alertBeans.get(key);
            fired = item.getAlertFired() == 1 | fired;
            if (item.getAlertFired() != 1) continue;
            alertsFired = alertsFired + item._alertItemName;
            alertsFired = alertsFired + ";";
        }
        Tuple<String> t = new Tuple<String>();
        t.add("0");
        AlertValueAndStatus summaryStatus = new AlertValueAndStatus(t, fired);
        if (!this._alertBeans.containsKey(summaryKey)) {
            item = new ClusterAlertSummary(summaryKey, summaryStatus);
            this.onNewAlertMbeanAdded(item);
            item.setAdditionalInfo(alertsFired);
            this._alertBeans.put(summaryKey, item);
            this._clusterAlertSummary = item;
        } else {
            this._alertBeans.get(summaryKey).setValueMap(summaryStatus);
            this._alertBeans.get(summaryKey).setAdditionalInfo(alertsFired);
        }
    }

    void register(Object bean, ObjectName name) {
        try {
            this._beanServer.unregisterMBean(name);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this._beanServer.registerMBean(bean, name);
        }
        catch (Exception e) {
            _logger.error((Object)"Could not register MBean", (Throwable)e);
        }
    }

    public void reset() {
        for (String beanName : this._alertBeans.keySet()) {
            ClusterAlertItem item = this._alertBeans.get(beanName);
            item.reset();
            try {
                ObjectName objectName = new ObjectName(DOMAIN_ALERT + ":alert=" + item.getSensorName());
                this._beanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                _logger.warn((Object)"", (Throwable)e);
            }
        }
        this._alertBeans.clear();
    }

    public void refreshAlertDelta(String clusterName) {
        String summaryKey = ALERT_SUMMARY + "_" + clusterName;
        HashSet<String> currentFiredAlerts = new HashSet<String>();
        for (String key : this._alertBeans.keySet()) {
            ClusterAlertItem item;
            if (key.equals(summaryKey) || (item = this._alertBeans.get(key)).getAlertFired() != 1) continue;
            currentFiredAlerts.add(item._alertItemName);
        }
        HashMap<String, String> onOffAlertsMap = new HashMap<String, String>();
        for (String alertName : currentFiredAlerts) {
            if (this._previousFiredAlerts.contains(alertName)) continue;
            onOffAlertsMap.put(alertName, "ON");
            _logger.info((Object)(alertName + " ON"));
            this._previousFiredAlerts.add(alertName);
        }
        for (String cachedAlert : this._previousFiredAlerts) {
            if (currentFiredAlerts.contains(cachedAlert)) continue;
            onOffAlertsMap.put(cachedAlert, "OFF");
            _logger.info((Object)(cachedAlert + " OFF"));
        }
        for (String key : onOffAlertsMap.keySet()) {
            if (!((String)onOffAlertsMap.get(key)).equals("OFF")) continue;
            this._previousFiredAlerts.remove(key);
        }
        if (onOffAlertsMap.size() == 0) {
            _logger.info((Object)"No MBean change");
        }
        this._recentAlertDelta = onOffAlertsMap;
        this.checkMBeanFreshness(300000L);
    }

    public Map<String, String> getRecentAlertDelta() {
        return this._recentAlertDelta;
    }

    void checkMBeanFreshness(long thresholdInMs) {
        ClusterAlertItem item;
        long now = new Date().getTime();
        HashSet<String> oldBeanNames = new HashSet<String>();
        for (String beanName : this._alertBeans.keySet()) {
            item = this._alertBeans.get(beanName);
            if (now - item.getLastUpdateTime() <= thresholdInMs) continue;
            oldBeanNames.add(beanName);
            _logger.info((Object)("bean " + beanName + " has not been updated for " + thresholdInMs + " MS"));
        }
        for (String beanName : oldBeanNames) {
            item = this._alertBeans.get(beanName);
            this._alertBeans.remove(beanName);
            try {
                item.reset();
                ObjectName objectName = new ObjectName(DOMAIN_ALERT + ":alert=" + item.getSensorName());
                this._beanServer.unregisterMBean(objectName);
            }
            catch (Exception e) {
                _logger.warn((Object)"", (Throwable)e);
            }
        }
    }

    class ClusterAlertSummary
    extends ClusterAlertItem
    implements ClusterAlertSummaryMBean {
        public ClusterAlertSummary(String name, AlertValueAndStatus valueAndStatus) {
            super(name, valueAndStatus);
        }

        @Override
        public String getAlertFiredHistory() {
            try {
                ObjectMapper mapper = new ObjectMapper();
                SerializationConfig serializationConfig = mapper.getSerializationConfig();
                serializationConfig.set(SerializationConfig.Feature.INDENT_OUTPUT, true);
                StringWriter sw = new StringWriter();
                mapper.writeValue((Writer)sw, (Object)ClusterAlertMBeanCollection.this._alertHistory);
                return sw.toString();
            }
            catch (Exception e) {
                _logger.warn((Object)"", (Throwable)e);
                return "";
            }
        }
    }

    public static interface ClusterAlertSummaryMBean
    extends ClusterAlertItemMBean {
        public String getAlertFiredHistory();
    }
}

