/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.handling.HelixStateTransitionHandler;
import org.apache.helix.messaging.handling.HelixTaskExecutor;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.participant.statemachine.StateModelParser;
import org.apache.log4j.Logger;

public class HelixStateMachineEngine
implements StateMachineEngine {
    private static Logger logger = Logger.getLogger(HelixStateMachineEngine.class);
    private final Map<String, Map<String, StateModelFactory<? extends StateModel>>> _stateModelFactoryMap;
    StateModelParser _stateModelParser = new StateModelParser();
    private final HelixManager _manager;
    private final ConcurrentHashMap<String, StateModelDefinition> _stateModelDefs;

    public StateModelFactory<? extends StateModel> getStateModelFactory(String stateModelName) {
        return this.getStateModelFactory(stateModelName, "DEFAULT");
    }

    public StateModelFactory<? extends StateModel> getStateModelFactory(String stateModelName, String factoryName) {
        if (!this._stateModelFactoryMap.containsKey(stateModelName)) {
            return null;
        }
        return this._stateModelFactoryMap.get(stateModelName).get(factoryName);
    }

    public HelixStateMachineEngine(HelixManager manager) {
        this._manager = manager;
        this._stateModelFactoryMap = new ConcurrentHashMap<String, Map<String, StateModelFactory<? extends StateModel>>>();
        this._stateModelDefs = new ConcurrentHashMap();
    }

    @Override
    public boolean registerStateModelFactory(String stateModelDef, StateModelFactory<? extends StateModel> factory) {
        return this.registerStateModelFactory(stateModelDef, factory, "DEFAULT");
    }

    @Override
    public boolean registerStateModelFactory(String stateModelName, StateModelFactory<? extends StateModel> factory, String factoryName) {
        if (stateModelName == null || factory == null || factoryName == null) {
            throw new HelixException("stateModelDef|stateModelFactory|factoryName cannot be null");
        }
        logger.info((Object)("Register state model factory for state model " + stateModelName + " using factory name " + factoryName + " with " + factory));
        if (!this._stateModelFactoryMap.containsKey(stateModelName)) {
            this._stateModelFactoryMap.put(stateModelName, new ConcurrentHashMap());
        }
        if (this._stateModelFactoryMap.get(stateModelName).containsKey(factoryName)) {
            logger.warn((Object)("stateModelFactory for " + stateModelName + " using factoryName " + factoryName + " has already been registered."));
            return false;
        }
        this._stateModelFactoryMap.get(stateModelName).put(factoryName, factory);
        this.sendNopMessage();
        return true;
    }

    private void sendNopMessage() {
        if (this._manager.isConnected()) {
            try {
                Message nopMsg = new Message(Message.MessageType.NO_OP, UUID.randomUUID().toString());
                nopMsg.setSrcName(this._manager.getInstanceName());
                HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
                PropertyKey.Builder keyBuilder = accessor.keyBuilder();
                if (this._manager.getInstanceType() == InstanceType.CONTROLLER || this._manager.getInstanceType() == InstanceType.CONTROLLER_PARTICIPANT) {
                    nopMsg.setTgtName("Controller");
                    accessor.setProperty(keyBuilder.controllerMessage(nopMsg.getId()), nopMsg);
                }
                if (this._manager.getInstanceType() == InstanceType.PARTICIPANT || this._manager.getInstanceType() == InstanceType.CONTROLLER_PARTICIPANT) {
                    nopMsg.setTgtName(this._manager.getInstanceName());
                    accessor.setProperty(keyBuilder.message(nopMsg.getTgtName(), nopMsg.getId()), nopMsg);
                }
                logger.info((Object)("Send NO_OP message to " + nopMsg.getTgtName() + ", msgId: " + nopMsg.getId()));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    public void reset() {
        for (Map<String, StateModelFactory<? extends StateModel>> ftyMap : this._stateModelFactoryMap.values()) {
            for (StateModelFactory<? extends StateModel> stateModelFactory : ftyMap.values()) {
                Map<String, ? extends StateModel> modelMap = stateModelFactory.getStateModelMap();
                if (modelMap == null || modelMap.isEmpty()) continue;
                for (String resourceKey : modelMap.keySet()) {
                    StateModel stateModel = modelMap.get(resourceKey);
                    stateModel.reset();
                    String initialState = this._stateModelParser.getInitialState(stateModel.getClass());
                    stateModel.updateState(initialState);
                }
            }
        }
    }

    @Override
    public MessageHandler createHandler(Message message, NotificationContext context) {
        StateModelFactory<? extends StateModel> stateModelFactory;
        String type = message.getMsgType();
        if (!type.equals(Message.MessageType.STATE_TRANSITION.toString())) {
            throw new HelixException("Unexpected msg type for message " + message.getMsgId() + " type:" + message.getMsgType());
        }
        String partitionKey = message.getPartitionName();
        String stateModelName = message.getStateModelDef();
        String resourceName = message.getResourceName();
        String sessionId = message.getTgtSessionId();
        int bucketSize = message.getBucketSize();
        if (stateModelName == null) {
            logger.error((Object)"message does not contain stateModelDef");
            return null;
        }
        String factoryName = message.getStateModelFactoryName();
        if (factoryName == null) {
            factoryName = "DEFAULT";
        }
        if ((stateModelFactory = this.getStateModelFactory(stateModelName, factoryName)) == null) {
            logger.warn((Object)("Cannot find stateModelFactory for model:" + stateModelName + " using factoryName:" + factoryName + " for resourceGroup:" + resourceName));
            return null;
        }
        if (!this._stateModelDefs.containsKey(stateModelName)) {
            PropertyKey.Builder keyBuilder;
            HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
            StateModelDefinition stateModelDef = (StateModelDefinition)accessor.getProperty((keyBuilder = accessor.keyBuilder()).stateModelDef(stateModelName));
            if (stateModelDef == null) {
                throw new HelixException("stateModelDef for " + stateModelName + " does NOT exists");
            }
            this._stateModelDefs.put(stateModelName, stateModelDef);
        }
        String initState = this._stateModelDefs.get(message.getStateModelDef()).getInitialState();
        StateModel stateModel = stateModelFactory.getStateModel(partitionKey);
        if (stateModel == null) {
            stateModelFactory.createAndAddStateModel(partitionKey);
            stateModel = stateModelFactory.getStateModel(partitionKey);
            stateModel.updateState(initState);
        }
        CurrentState currentStateDelta = new CurrentState(resourceName);
        currentStateDelta.setSessionId(sessionId);
        currentStateDelta.setStateModelDefRef(stateModelName);
        currentStateDelta.setStateModelFactoryName(factoryName);
        currentStateDelta.setBucketSize(bucketSize);
        currentStateDelta.setState(partitionKey, stateModel.getCurrentState() == null ? initState : stateModel.getCurrentState());
        HelixTaskExecutor executor = (HelixTaskExecutor)context.get("TASK_EXECUTOR");
        return new HelixStateTransitionHandler(stateModel, message, context, currentStateDelta, executor);
    }

    @Override
    public String getMessageType() {
        return Message.MessageType.STATE_TRANSITION.toString();
    }

    @Override
    public boolean removeStateModelFactory(String stateModelDef, StateModelFactory<? extends StateModel> factory) {
        throw new UnsupportedOperationException("Remove not yet supported");
    }

    @Override
    public boolean removeStateModelFactory(String stateModelDef, StateModelFactory<? extends StateModel> factory, String factoryName) {
        throw new UnsupportedOperationException("Remove not yet supported");
    }
}

