/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant.statemachine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.helix.participant.statemachine.StateModel;

public abstract class StateModelFactory<T extends StateModel> {
    private ConcurrentMap<String, T> _stateModelMap = new ConcurrentHashMap<String, T>();

    public abstract T createNewStateModel(String var1);

    public void addStateModel(String partitionName, T stateModel) {
        this._stateModelMap.put(partitionName, stateModel);
    }

    public void createAndAddStateModel(String partitionName) {
        this._stateModelMap.put(partitionName, this.createNewStateModel(partitionName));
    }

    public T getStateModel(String partitionName) {
        return (T)((StateModel)this._stateModelMap.get(partitionName));
    }

    public Map<String, T> getStateModelMap() {
        return this._stateModelMap;
    }
}

