/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant.statemachine;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;

public class StateModelParser {
    public Method getMethodForTransition(Class<? extends StateModel> clazz, String fromState, String toState, Class<?>[] paramTypes) {
        Method method = this.getMethodForTransitionUsingAnnotation(clazz, fromState, toState, paramTypes);
        if (method == null) {
            method = this.getMethodForTransitionByConvention(clazz, fromState, toState, paramTypes);
        }
        return method;
    }

    public Method getMethodForTransitionByConvention(Class<? extends StateModel> clazz, String fromState, String toState, Class<?>[] paramTypes) {
        Method[] methods;
        Method methodToInvoke = null;
        String methodName = "onBecome" + toState + "From" + fromState;
        if (fromState.equals("*")) {
            methodName = "onBecome" + toState;
        }
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equalsIgnoreCase(methodName) || (parameterTypes = method.getParameterTypes()).length != 2 || !parameterTypes[0].equals(Message.class) || !parameterTypes[1].equals(NotificationContext.class)) continue;
            methodToInvoke = method;
            break;
        }
        return methodToInvoke;
    }

    public Method getMethodForTransitionUsingAnnotation(Class<? extends StateModel> clazz, String fromState, String toState, Class<?>[] paramTypes) {
        Method[] methods;
        StateModelInfo stateModelInfo = clazz.getAnnotation(StateModelInfo.class);
        Method methodToInvoke = null;
        if (stateModelInfo != null && (methods = clazz.getMethods()) != null) {
            for (Method method : methods) {
                Transition annotation = method.getAnnotation(Transition.class);
                if (annotation == null) continue;
                boolean matchesFrom = annotation.from().equalsIgnoreCase(fromState);
                boolean matchesTo = annotation.to().equalsIgnoreCase(toState);
                boolean matchesParamTypes = Arrays.equals(paramTypes, method.getParameterTypes());
                if (!matchesFrom || !matchesTo || !matchesParamTypes) continue;
                methodToInvoke = method;
                break;
            }
        }
        return methodToInvoke;
    }

    public String getInitialState(Class<? extends StateModel> clazz) {
        StateModelInfo stateModelInfo = clazz.getAnnotation(StateModelInfo.class);
        if (stateModelInfo != null) {
            return stateModelInfo.initialState();
        }
        return "OFFLINE";
    }
}

