/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesReader {
    private static final Logger LOG = Logger.getLogger((String)PropertiesReader.class.getName());
    private final Properties _properties = new Properties();

    public PropertiesReader(String propertyFileName) {
        try {
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(propertyFileName);
            this._properties.load(stream);
        }
        catch (Exception e) {
            String errMsg = "could not open properties file:" + propertyFileName;
            throw new IllegalArgumentException(errMsg, e);
        }
    }

    public String getProperty(String key) {
        String value = this._properties.getProperty(key);
        if (value == null) {
            throw new IllegalArgumentException("no property exist for key:" + key);
        }
        return value;
    }
}

