/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.model.StateModelDefinition;

public class StateModelConfigGenerator {
    public static void main(String[] args) {
        ZNRecordSerializer serializer = new ZNRecordSerializer();
        StateModelConfigGenerator generator = new StateModelConfigGenerator();
        System.out.println(new String(serializer.serialize(generator.generateConfigForMasterSlave())));
    }

    public ZNRecord generateConfigForStorageSchemata() {
        HashMap<String, String> metadata;
        String key;
        ZNRecord record = new ZNRecord("STORAGE_DEFAULT_SM_SCHEMATA");
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), "OFFLINE");
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add("MASTER");
        statePriorityList.add("OFFLINE");
        statePriorityList.add("DROPPED");
        statePriorityList.add("ERROR");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            key = state + ".meta";
            metadata = new HashMap<String, String>();
            if (state.equals("MASTER")) {
                metadata.put("count", "N");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("OFFLINE")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("DROPPED")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
                continue;
            }
            if (!state.equals("ERROR")) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        for (String state : statePriorityList) {
            key = state + ".next";
            if (state.equals("MASTER")) {
                metadata = new HashMap();
                metadata.put("OFFLINE", "OFFLINE");
                metadata.put("DROPPED", "OFFLINE");
                record.setMapField(key, metadata);
            }
            if (state.equals("OFFLINE")) {
                metadata = new HashMap();
                metadata.put("MASTER", "MASTER");
                metadata.put("DROPPED", "DROPPED");
                record.setMapField(key, metadata);
            }
            if (!state.equals("ERROR")) continue;
            metadata = new HashMap();
            metadata.put("OFFLINE", "OFFLINE");
            record.setMapField(key, metadata);
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("MASTER-OFFLINE");
        stateTransitionPriorityList.add("OFFLINE-MASTER");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }

    public ZNRecord generateConfigForMasterSlave() {
        HashMap<String, String> metadata;
        String key;
        ZNRecord record = new ZNRecord("MasterSlave");
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), "OFFLINE");
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add("MASTER");
        statePriorityList.add("SLAVE");
        statePriorityList.add("OFFLINE");
        statePriorityList.add("DROPPED");
        statePriorityList.add("ERROR");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            key = state + ".meta";
            metadata = new HashMap<String, String>();
            if (state.equals("MASTER")) {
                metadata.put("count", "1");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("SLAVE")) {
                metadata.put("count", "R");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("OFFLINE")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("DROPPED")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
                continue;
            }
            if (!state.equals("ERROR")) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        for (String state : statePriorityList) {
            key = state + ".next";
            if (state.equals("MASTER")) {
                metadata = new HashMap();
                metadata.put("SLAVE", "SLAVE");
                metadata.put("OFFLINE", "SLAVE");
                metadata.put("DROPPED", "SLAVE");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("SLAVE")) {
                metadata = new HashMap();
                metadata.put("MASTER", "MASTER");
                metadata.put("OFFLINE", "OFFLINE");
                metadata.put("DROPPED", "OFFLINE");
                record.setMapField(key, metadata);
                continue;
            }
            if (state.equals("OFFLINE")) {
                metadata = new HashMap();
                metadata.put("SLAVE", "SLAVE");
                metadata.put("MASTER", "SLAVE");
                metadata.put("DROPPED", "DROPPED");
                record.setMapField(key, metadata);
                continue;
            }
            if (!state.equals("ERROR")) continue;
            metadata = new HashMap();
            metadata.put("OFFLINE", "OFFLINE");
            record.setMapField(key, metadata);
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("MASTER-SLAVE");
        stateTransitionPriorityList.add("SLAVE-MASTER");
        stateTransitionPriorityList.add("OFFLINE-SLAVE");
        stateTransitionPriorityList.add("SLAVE-OFFLINE");
        stateTransitionPriorityList.add("OFFLINE-DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }

    public ZNRecord generateConfigForLeaderStandby() {
        HashMap<String, String> metadata;
        String key;
        ZNRecord record = new ZNRecord("LeaderStandby");
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), "OFFLINE");
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add("LEADER");
        statePriorityList.add("STANDBY");
        statePriorityList.add("OFFLINE");
        statePriorityList.add("DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            key = state + ".meta";
            metadata = new HashMap<String, String>();
            if (state.equals("LEADER")) {
                metadata.put("count", "1");
                record.setMapField(key, metadata);
            }
            if (state.equals("STANDBY")) {
                metadata.put("count", "R");
                record.setMapField(key, metadata);
            }
            if (state.equals("OFFLINE")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
            }
            if (!state.equals("DROPPED")) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        for (String state : statePriorityList) {
            key = state + ".next";
            if (state.equals("LEADER")) {
                metadata = new HashMap();
                metadata.put("STANDBY", "STANDBY");
                metadata.put("OFFLINE", "STANDBY");
                metadata.put("DROPPED", "STANDBY");
                record.setMapField(key, metadata);
            }
            if (state.equals("STANDBY")) {
                metadata = new HashMap();
                metadata.put("LEADER", "LEADER");
                metadata.put("OFFLINE", "OFFLINE");
                metadata.put("DROPPED", "OFFLINE");
                record.setMapField(key, metadata);
            }
            if (!state.equals("OFFLINE")) continue;
            metadata = new HashMap();
            metadata.put("STANDBY", "STANDBY");
            metadata.put("LEADER", "STANDBY");
            metadata.put("DROPPED", "DROPPED");
            record.setMapField(key, metadata);
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("LEADER-STANDBY");
        stateTransitionPriorityList.add("STANDBY-LEADER");
        stateTransitionPriorityList.add("OFFLINE-STANDBY");
        stateTransitionPriorityList.add("STANDBY-OFFLINE");
        stateTransitionPriorityList.add("OFFLINE-DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }

    public ZNRecord generateConfigForOnlineOffline() {
        HashMap<String, String> metadata;
        String key;
        ZNRecord record = new ZNRecord("OnlineOffline");
        record.setSimpleField(StateModelDefinition.StateModelDefinitionProperty.INITIAL_STATE.toString(), "OFFLINE");
        ArrayList<String> statePriorityList = new ArrayList<String>();
        statePriorityList.add("ONLINE");
        statePriorityList.add("OFFLINE");
        statePriorityList.add("DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
        for (String state : statePriorityList) {
            key = state + ".meta";
            metadata = new HashMap<String, String>();
            if (state.equals("ONLINE")) {
                metadata.put("count", "R");
                record.setMapField(key, metadata);
            }
            if (state.equals("OFFLINE")) {
                metadata.put("count", "-1");
                record.setMapField(key, metadata);
            }
            if (!state.equals("DROPPED")) continue;
            metadata.put("count", "-1");
            record.setMapField(key, metadata);
        }
        for (String state : statePriorityList) {
            key = state + ".next";
            if (state.equals("ONLINE")) {
                metadata = new HashMap();
                metadata.put("OFFLINE", "OFFLINE");
                metadata.put("DROPPED", "OFFLINE");
                record.setMapField(key, metadata);
            }
            if (!state.equals("OFFLINE")) continue;
            metadata = new HashMap();
            metadata.put("ONLINE", "ONLINE");
            metadata.put("DROPPED", "DROPPED");
            record.setMapField(key, metadata);
        }
        ArrayList<String> stateTransitionPriorityList = new ArrayList<String>();
        stateTransitionPriorityList.add("OFFLINE-ONLINE");
        stateTransitionPriorityList.add("ONLINE-OFFLINE");
        stateTransitionPriorityList.add("OFFLINE-DROPPED");
        record.setListField(StateModelDefinition.StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), stateTransitionPriorityList);
        return record;
    }
}

