/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.zookeeper.ZooKeeper;

public class ZKClientPool {
    static final Map<String, ZkClient> _zkClientMap = new ConcurrentHashMap<String, ZkClient>();
    static final int DEFAULT_SESSION_TIMEOUT = 30000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZkClient getZkClient(String zkServer) {
        ZkClient zkClient;
        if (_zkClientMap.containsKey(zkServer) && (zkClient = _zkClientMap.get(zkServer)).getConnection().getZookeeperState() == ZooKeeper.States.CONNECTED) {
            return zkClient;
        }
        Map<String, ZkClient> map = _zkClientMap;
        synchronized (map) {
            ZkClient zkClient2;
            if (_zkClientMap.containsKey(zkServer) && (zkClient2 = _zkClientMap.get(zkServer)).getConnection().getZookeeperState() != ZooKeeper.States.CONNECTED) {
                _zkClientMap.remove(zkServer);
            }
            if (!_zkClientMap.containsKey(zkServer)) {
                zkClient2 = new ZkClient(zkServer, 30000, 60000, new ZNRecordSerializer());
                _zkClientMap.put(zkServer, zkClient2);
            }
            return _zkClientMap.get(zkServer);
        }
    }

    public static void reset() {
        _zkClientMap.clear();
    }
}

