/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.BaseDataAccessor;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

public class GroupCommit {
    private static Logger LOG = Logger.getLogger(GroupCommit.class);
    private final Queue[] _queues = new Queue[100];

    public GroupCommit() {
        for (int i = 0; i < this._queues.length; ++i) {
            this._queues[i] = new Queue();
        }
    }

    private Queue getQueue(String key) {
        return this._queues[(key.hashCode() & Integer.MAX_VALUE) % this._queues.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(BaseDataAccessor<ZNRecord> accessor, int options, String key, ZNRecord record) {
        Queue queue = this.getQueue(key);
        Entry entry = new Entry(key, record);
        queue._pending.add(entry);
        while (!entry._sent.get()) {
            if (queue._running.compareAndSet(null, Thread.currentThread())) {
                Iterator i$;
                ArrayList<Entry> processed;
                block27: {
                    processed = new ArrayList<Entry>();
                    if (queue._pending.peek() != null) break block27;
                    boolean bl = true;
                    queue._running.set(null);
                    Iterator i$2 = processed.iterator();
                    while (i$2.hasNext()) {
                        Entry e;
                        Entry entry2 = e = (Entry)i$2.next();
                        synchronized (entry2) {
                            e._sent.set(true);
                            e.notify();
                        }
                    }
                    return bl;
                }
                try {
                    Entry first = queue._pending.poll();
                    processed.add(first);
                    String mergedKey = first._key;
                    ZNRecord merged = null;
                    try {
                        merged = accessor.get(mergedKey, null, options);
                    }
                    catch (ZkNoNodeException e) {
                        // empty catch block
                    }
                    if (merged == null) {
                        merged = new ZNRecord(first._record);
                    } else {
                        merged.merge(first._record);
                    }
                    Iterator<Entry> it = queue._pending.iterator();
                    while (it.hasNext()) {
                        Entry ent = it.next();
                        if (!ent._key.equals(mergedKey)) continue;
                        processed.add(ent);
                        merged.merge(ent._record);
                        it.remove();
                    }
                    accessor.set(mergedKey, merged, options);
                    queue._running.set(null);
                    i$ = processed.iterator();
                }
                catch (Throwable throwable) {
                    queue._running.set(null);
                    Iterator i$3 = processed.iterator();
                    while (i$3.hasNext()) {
                        Entry e;
                        Entry entry3 = e = (Entry)i$3.next();
                        synchronized (entry3) {
                            e._sent.set(true);
                            e.notify();
                        }
                    }
                    throw throwable;
                }
                while (i$.hasNext()) {
                    Entry e;
                    Entry entry4 = e = (Entry)i$.next();
                    synchronized (entry4) {
                        e._sent.set(true);
                        e.notify();
                    }
                }
                continue;
            }
            Entry entry5 = entry;
            synchronized (entry5) {
                try {
                    entry.wait(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return true;
    }

    private static class Entry {
        final String _key;
        final ZNRecord _record;
        AtomicBoolean _sent = new AtomicBoolean(false);

        Entry(String key, ZNRecord record) {
            this._key = key;
            this._record = record;
        }
    }

    private static class Queue {
        final AtomicReference<Thread> _running = new AtomicReference();
        final ConcurrentLinkedQueue<Entry> _pending = new ConcurrentLinkedQueue();

        private Queue() {
        }
    }
}

