/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.josql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixProperty;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.josql.ZNRecordJosqlFunctionHandler;
import org.apache.helix.josql.ZNRecordRow;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.LiveInstance;
import org.apache.log4j.Logger;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;

public class ClusterJosqlQueryProcessor {
    public static final String PARTITIONS = "PARTITIONS";
    public static final String FLATTABLE = ".Table";
    HelixManager _manager;
    private static Logger _logger = Logger.getLogger(ClusterJosqlQueryProcessor.class);

    public ClusterJosqlQueryProcessor(HelixManager manager) {
        this._manager = manager;
    }

    String parseFromTarget(String sql) {
        String fromTarget;
        int fromIndex = sql.indexOf("FROM");
        if (fromIndex == -1) {
            throw new HelixException("Query must contain FROM target. Query: " + sql);
        }
        int nextSpace = sql.indexOf(" ", fromIndex);
        while (sql.charAt(nextSpace) == ' ') {
            ++nextSpace;
        }
        int nextnextSpace = sql.indexOf(" ", nextSpace);
        if (nextnextSpace == -1) {
            nextnextSpace = sql.length();
        }
        if ((fromTarget = sql.substring(nextSpace, nextnextSpace).trim()).length() == 0) {
            throw new HelixException("FROM target in the query cannot be empty. Query: " + sql);
        }
        return fromTarget;
    }

    public List<Object> runJoSqlQuery(String josql, Map<String, Object> bindVariables, List<Object> additionalFunctionHandlers, List queryTarget) throws QueryParseException, QueryExecutionException {
        Query josqlQuery = this.prepareQuery(bindVariables, additionalFunctionHandlers);
        josqlQuery.parse(josql);
        QueryResults qr = josqlQuery.execute(queryTarget);
        return qr.getResults();
    }

    Query prepareQuery(Map<String, Object> bindVariables, List<Object> additionalFunctionHandlers) {
        HelixDataAccessor accessor = this._manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List<ZNRecord> instanceConfigs = HelixProperty.convertToList(accessor.getChildValues(keyBuilder.instanceConfigs()));
        List<ZNRecord> liveInstances = HelixProperty.convertToList(accessor.getChildValues(keyBuilder.liveInstances()));
        List<ZNRecord> stateModelDefs = HelixProperty.convertToList(accessor.getChildValues(keyBuilder.stateModelDefs()));
        List<ZNRecord> idealStateList = HelixProperty.convertToList(accessor.getChildValues(keyBuilder.idealStates()));
        HashMap<String, ZNRecord> idealStatesMap = new HashMap<String, ZNRecord>();
        for (ZNRecord idealState : idealStateList) {
            idealStatesMap.put(idealState.getId(), idealState);
        }
        ArrayList<ZNRecord> partitions = new ArrayList<ZNRecord>();
        for (ZNRecord idealState : idealStateList) {
            for (String partitionName : idealState.getMapFields().keySet()) {
                partitions.add(new ZNRecord(partitionName));
            }
        }
        List<ZNRecord> externalViewList = HelixProperty.convertToList(accessor.getChildValues(keyBuilder.externalViews()));
        HashMap<String, ZNRecord> externalViewMap = new HashMap<String, ZNRecord>();
        for (ZNRecord externalView : externalViewList) {
            externalViewMap.put(externalView.getId(), externalView);
        }
        HashMap currentStatesMap = new HashMap();
        HashMap<String, List<ZNRecordRow>> flatCurrentStateMap = new HashMap<String, List<ZNRecordRow>>();
        for (ZNRecord instance : liveInstances) {
            String host = instance.getId();
            String sessionId = instance.getSimpleField(LiveInstance.LiveInstanceProperty.SESSION_ID.toString());
            HashMap<String, ZNRecord> currentStates = new HashMap<String, ZNRecord>();
            ArrayList<ZNRecord> instanceCurrentStateList = new ArrayList<ZNRecord>();
            for (ZNRecord idealState : idealStateList) {
                String resourceName = idealState.getId();
                Object property = accessor.getProperty(keyBuilder.currentState(host, sessionId, resourceName));
                ZNRecord currentState = null;
                if (property == null) {
                    _logger.warn((Object)("Resource " + resourceName + " has null currentState"));
                    currentState = new ZNRecord(resourceName);
                } else {
                    currentState = ((HelixProperty)property).getRecord();
                }
                currentStates.put(resourceName, currentState);
                instanceCurrentStateList.add(currentState);
            }
            currentStatesMap.put(host, currentStates);
            flatCurrentStateMap.put(host, ZNRecordRow.flatten(instanceCurrentStateList));
        }
        Query josqlQuery = new Query();
        josqlQuery.setVariable(PropertyType.CONFIGS.toString() + "/" + HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceConfigs);
        josqlQuery.setVariable(PropertyType.IDEALSTATES.toString(), idealStatesMap);
        josqlQuery.setVariable(PropertyType.LIVEINSTANCES.toString(), liveInstances);
        josqlQuery.setVariable(PropertyType.STATEMODELDEFS.toString(), stateModelDefs);
        josqlQuery.setVariable(PropertyType.EXTERNALVIEW.toString(), externalViewMap);
        josqlQuery.setVariable(PropertyType.CURRENTSTATES.toString(), currentStatesMap);
        josqlQuery.setVariable(PARTITIONS, partitions);
        josqlQuery.setVariable(PropertyType.CONFIGS.toString() + "/" + HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString() + FLATTABLE, ZNRecordRow.flatten(instanceConfigs));
        josqlQuery.setVariable(PropertyType.IDEALSTATES.toString() + FLATTABLE, ZNRecordRow.flatten(idealStateList));
        josqlQuery.setVariable(PropertyType.LIVEINSTANCES.toString() + FLATTABLE, ZNRecordRow.flatten(liveInstances));
        josqlQuery.setVariable(PropertyType.STATEMODELDEFS.toString() + FLATTABLE, ZNRecordRow.flatten(stateModelDefs));
        josqlQuery.setVariable(PropertyType.EXTERNALVIEW.toString() + FLATTABLE, ZNRecordRow.flatten(externalViewList));
        josqlQuery.setVariable(PropertyType.CURRENTSTATES.toString() + FLATTABLE, flatCurrentStateMap.values());
        josqlQuery.setVariable("PARTITIONS.Table", ZNRecordRow.flatten(partitions));
        if (bindVariables != null) {
            for (String key : bindVariables.keySet()) {
                josqlQuery.setVariable(key, bindVariables.get(key));
            }
        }
        josqlQuery.addFunctionHandler((Object)new ZNRecordJosqlFunctionHandler());
        josqlQuery.addFunctionHandler((Object)new ZNRecordRow());
        josqlQuery.addFunctionHandler((Object)new Integer(0));
        if (additionalFunctionHandlers != null) {
            for (Object functionHandler : additionalFunctionHandlers) {
                josqlQuery.addFunctionHandler(functionHandler);
            }
        }
        return josqlQuery;
    }

    public List<Object> runJoSqlQuery(String josql, Map<String, Object> bindVariables, List<Object> additionalFunctionHandlers) throws QueryParseException, QueryExecutionException {
        Query josqlQuery = this.prepareQuery(bindVariables, additionalFunctionHandlers);
        String fromTargetString = this.parseFromTarget(josql);
        List fromTargetList = null;
        Object fromTarget = null;
        if (fromTargetString.equalsIgnoreCase(PARTITIONS)) {
            fromTarget = josqlQuery.getVariable(PARTITIONS.toString());
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.LIVEINSTANCES.toString())) {
            fromTarget = josqlQuery.getVariable(PropertyType.LIVEINSTANCES.toString());
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.CONFIGS.toString() + "/" + HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString())) {
            fromTarget = josqlQuery.getVariable(PropertyType.CONFIGS.toString() + "/" + HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.STATEMODELDEFS.toString())) {
            fromTarget = josqlQuery.getVariable(PropertyType.STATEMODELDEFS.toString());
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.EXTERNALVIEW.toString())) {
            fromTarget = josqlQuery.getVariable(PropertyType.EXTERNALVIEW.toString());
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.IDEALSTATES.toString())) {
            fromTarget = josqlQuery.getVariable(PropertyType.IDEALSTATES.toString());
        } else if (fromTargetString.equalsIgnoreCase("PARTITIONS.Table")) {
            fromTarget = josqlQuery.getVariable(PARTITIONS.toString() + FLATTABLE);
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.LIVEINSTANCES.toString() + FLATTABLE)) {
            fromTarget = josqlQuery.getVariable(PropertyType.LIVEINSTANCES.toString() + FLATTABLE);
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.CONFIGS.toString() + "/" + HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString() + FLATTABLE)) {
            fromTarget = josqlQuery.getVariable(PropertyType.CONFIGS.toString() + "/" + HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString() + FLATTABLE);
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.STATEMODELDEFS.toString() + FLATTABLE)) {
            fromTarget = josqlQuery.getVariable(PropertyType.STATEMODELDEFS.toString() + FLATTABLE);
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.EXTERNALVIEW.toString() + FLATTABLE)) {
            fromTarget = josqlQuery.getVariable(PropertyType.EXTERNALVIEW.toString() + FLATTABLE);
        } else if (fromTargetString.equalsIgnoreCase(PropertyType.IDEALSTATES.toString() + FLATTABLE)) {
            fromTarget = josqlQuery.getVariable(PropertyType.IDEALSTATES.toString() + FLATTABLE);
        } else {
            throw new HelixException("Unknown query target " + fromTargetString + ". Target should be PARTITIONS, LIVEINSTANCES, CONFIGS, STATEMODELDEFS, IDEALSTATES, EXTERNALVIEW, and corresponding flat Tables");
        }
        fromTargetList = fromTargetString.endsWith(FLATTABLE) ? (List)fromTarget : (List)fromTarget;
        josql = josql.replaceFirst(fromTargetString, fromTargetString.endsWith(FLATTABLE) ? ZNRecordRow.class.getName() : ZNRecord.class.getName());
        josqlQuery.parse(josql);
        QueryResults qr = josqlQuery.execute(fromTargetList);
        return qr.getResults();
    }
}

