/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.LinkedList;
import java.util.List;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkConnection;
import org.apache.helix.manager.zk.ZKHelixManager;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class ZkStateChangeListener
implements IZkStateListener {
    private volatile boolean _isConnected;
    private volatile boolean _hasSessionExpired;
    private final ZKHelixManager _zkHelixManager;
    List<Long> _disconnectTimeHistory = new LinkedList<Long>();
    int _timeWindowLengthMs;
    int _maxDisconnectThreshold;
    private static Logger logger = Logger.getLogger(ZkStateChangeListener.class);

    public ZkStateChangeListener(ZKHelixManager zkHelixManager, int timeWindowLengthMs, int maxDisconnectThreshold) {
        this._zkHelixManager = zkHelixManager;
        this._timeWindowLengthMs = timeWindowLengthMs;
        this._maxDisconnectThreshold = maxDisconnectThreshold > 0 ? maxDisconnectThreshold : 1;
    }

    public void handleNewSession() {
        this._isConnected = true;
        this._hasSessionExpired = false;
        this._zkHelixManager.handleNewSession();
    }

    public void handleStateChanged(Watcher.Event.KeeperState keeperState) throws Exception {
        switch (keeperState) {
            case SyncConnected: {
                ZkConnection zkConnection = (ZkConnection)this._zkHelixManager._zkClient.getConnection();
                logger.info((Object)("KeeperState: " + keeperState + ", zookeeper:" + zkConnection.getZookeeper()));
                this._isConnected = true;
                break;
            }
            case Disconnected: {
                logger.info((Object)("KeeperState:" + keeperState + ", disconnectedSessionId: " + this._zkHelixManager._sessionId + ", instance: " + this._zkHelixManager.getInstanceName() + ", type: " + (Object)((Object)this._zkHelixManager.getInstanceType())));
                this._isConnected = false;
                this._disconnectTimeHistory.add(System.currentTimeMillis());
                if (!this.isFlapping()) break;
                logger.error((Object)("isFlapping() returns true, so disconnect the helix manager. " + this._zkHelixManager.getInstanceName() + " " + this._maxDisconnectThreshold + " disconnects in " + this._timeWindowLengthMs + " Ms."));
                this._zkHelixManager.disconnectInternal();
                break;
            }
            case Expired: {
                logger.info((Object)("KeeperState:" + keeperState + ", expiredSessionId: " + this._zkHelixManager._sessionId + ", instance: " + this._zkHelixManager.getInstanceName() + ", type: " + (Object)((Object)this._zkHelixManager.getInstanceType())));
                this._isConnected = false;
                this._hasSessionExpired = true;
            }
        }
    }

    boolean isConnected() {
        return this._isConnected;
    }

    void disconnect() {
        this._isConnected = false;
    }

    boolean hasSessionExpired() {
        return this._hasSessionExpired;
    }

    boolean isFlapping() {
        if (this._disconnectTimeHistory.size() == 0) {
            return false;
        }
        long mostRecentTimestamp = this._disconnectTimeHistory.get(this._disconnectTimeHistory.size() - 1);
        while (this._disconnectTimeHistory.get(0) + (long)this._timeWindowLengthMs < mostRecentTimestamp) {
            this._disconnectTimeHistory.remove(0);
        }
        return this._disconnectTimeHistory.size() > this._maxDisconnectThreshold;
    }
}

