/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet;

import java.io.Serializable;
import org.apache.heron.api.Config;
import org.apache.heron.streamlet.impl.KryoSerializer;

public final class Config
implements Serializable {
    private static final long serialVersionUID = 6204498077403076352L;
    private final double cpu;
    private final long ram;
    private final DeliverySemantics deliverySemantics;
    private final Serializer serializer;
    private org.apache.heron.api.Config heronConfig;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;

    private Config(Builder builder) {
        this.serializer = builder.serializer;
        this.heronConfig = builder.config;
        this.cpu = builder.cpu;
        this.ram = builder.ram;
        this.deliverySemantics = builder.deliverySemantics;
    }

    public static Config defaultConfig() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public org.apache.heron.api.Config getHeronConfig() {
        return this.heronConfig;
    }

    public double getPerContainerCpu() {
        return this.cpu;
    }

    public long getPerContainerRam() {
        return this.ram;
    }

    public long getPerContainerRamAsGigabytes() {
        return Math.round((double)this.ram / 1.073741824E9);
    }

    public long getPerContainerRamAsMegabytes() {
        return Math.round((double)this.ram / 1048576.0);
    }

    public long getPerContainerRamAsBytes() {
        return this.getPerContainerRam();
    }

    public DeliverySemantics getDeliverySemantics() {
        return this.deliverySemantics;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    private static Config.TopologyReliabilityMode translateSemantics(DeliverySemantics semantics) {
        switch (semantics) {
            case ATMOST_ONCE: {
                return Config.TopologyReliabilityMode.ATMOST_ONCE;
            }
            case ATLEAST_ONCE: {
                return Config.TopologyReliabilityMode.ATLEAST_ONCE;
            }
            case EFFECTIVELY_ONCE: {
                return Config.TopologyReliabilityMode.EFFECTIVELY_ONCE;
            }
        }
        return Config.TopologyReliabilityMode.ATMOST_ONCE;
    }

    public static final class Builder {
        private org.apache.heron.api.Config config = Defaults.CONFIG;
        private double cpu = 1.0;
        private long ram = 0x6400000L;
        private DeliverySemantics deliverySemantics = Defaults.SEMANTICS;
        private Serializer serializer = Serializer.KRYO;

        private Builder() {
        }

        public Builder setPerContainerCpu(double perContainerCpu) {
            this.cpu = perContainerCpu;
            return this;
        }

        public Builder setPerContainerRam(long perContainerRam) {
            this.ram = perContainerRam;
            return this;
        }

        public Builder setPerContainerRamInBytes(long perContainerRam) {
            this.ram = perContainerRam;
            return this;
        }

        public Builder setPerContainerRamInMegabytes(long perContainerRamMB) {
            this.ram = perContainerRamMB * 0x100000L;
            return this;
        }

        public Builder setPerContainerRamInGigabytes(long perContainerRamGB) {
            this.ram = perContainerRamGB * 0x40000000L;
            return this;
        }

        public Builder setNumContainers(int numContainers) {
            this.config.setNumStmgrs(numContainers);
            return this;
        }

        public Builder setDeliverySemantics(DeliverySemantics semantics) {
            this.deliverySemantics = semantics;
            this.config.setTopologyReliabilityMode(Config.translateSemantics(semantics));
            return this;
        }

        public Builder setUserConfig(String key, Object value) {
            this.config.put(key, value);
            return this;
        }

        private void useKryo() {
            try {
                this.config.setSerializationClassName(KryoSerializer.class.getName());
            }
            catch (NoClassDefFoundError e) {
                throw new RuntimeException("Linking with kryo is needed because useKryoSerializer is used");
            }
        }

        public Builder setSerializer(Serializer topologySerializer) {
            this.serializer = topologySerializer;
            return this;
        }

        public Config build() {
            if (this.serializer.equals((Object)Serializer.KRYO)) {
                this.useKryo();
            }
            return new Config(this);
        }
    }

    private static class Defaults {
        static final boolean USE_KRYO = true;
        static final org.apache.heron.api.Config CONFIG = new org.apache.heron.api.Config();
        static final double CPU = 1.0;
        static final long RAM = 0x6400000L;
        static final DeliverySemantics SEMANTICS = DeliverySemantics.ATMOST_ONCE;
        static final Serializer SERIALIZER = Serializer.KRYO;

        private Defaults() {
        }
    }

    public static enum Serializer {
        JAVA,
        KRYO;

    }

    public static enum DeliverySemantics {
        ATMOST_ONCE,
        ATLEAST_ONCE,
        EFFECTIVELY_ONCE;

    }
}

