/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.Builder;
import org.apache.heron.streamlet.SerializableSupplier;
import org.apache.heron.streamlet.Source;
import org.apache.heron.streamlet.Streamlet;
import org.apache.heron.streamlet.impl.StreamletImpl;

public final class BuilderImpl
implements Builder {
    private List<StreamletImpl<?>> sources = new LinkedList();

    @Override
    public <R> Streamlet<R> newSource(SerializableSupplier<R> supplier) {
        StreamletImpl<R> retval = StreamletImpl.createSupplierStreamlet(supplier);
        retval.setNumPartitions(1);
        this.sources.add(retval);
        return retval;
    }

    @Override
    public <R> Streamlet<R> newSource(Source<R> generator) {
        StreamletImpl<R> retval = StreamletImpl.createGeneratorStreamlet(generator);
        retval.setNumPartitions(1);
        this.sources.add(retval);
        return retval;
    }

    public TopologyBuilder build() {
        TopologyBuilder builder = new TopologyBuilder();
        return this.build(builder);
    }

    public TopologyBuilder build(TopologyBuilder builder) {
        HashSet<String> stageNames = new HashSet<String>();
        for (StreamletImpl<?> streamlet : this.sources) {
            streamlet.build(builder, stageNames);
        }
        for (StreamletImpl<?> streamlet : this.sources) {
            if (streamlet.allBuilt()) continue;
            throw new RuntimeException("Topology cannot be fully built! Are all sources added?");
        }
        return builder;
    }
}

