/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.groupings;

import java.util.ArrayList;
import java.util.List;
import org.apache.heron.api.grouping.CustomStreamGrouping;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.utils.Utils;
import org.apache.heron.streamlet.SerializableFunction;

public class ReduceByKeyAndWindowCustomGrouping<K, V>
implements CustomStreamGrouping {
    private static final long serialVersionUID = -7630948017550637716L;
    private SerializableFunction<V, K> keyExtractor;
    private List<Integer> taskIds;

    public ReduceByKeyAndWindowCustomGrouping(SerializableFunction<V, K> keyExtractor) {
        this.keyExtractor = keyExtractor;
    }

    @Override
    public void prepare(TopologyContext context, String component, String streamId, List<Integer> targetTasks) {
        this.taskIds = targetTasks;
    }

    @Override
    public List<Integer> chooseTasks(List<Object> values) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Object obj = values.get(0);
        int key = this.keyExtractor.apply(obj).hashCode();
        ret.add(Utils.assignKeyToTask(key, this.taskIds));
        return ret;
    }
}

