/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.operators;

import java.util.Map;
import org.apache.heron.api.bolt.OutputCollector;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.api.tuple.Values;
import org.apache.heron.streamlet.SerializablePredicate;
import org.apache.heron.streamlet.impl.operators.StreamletOperator;

public class FilterOperator<R>
extends StreamletOperator {
    private static final long serialVersionUID = -4748646871471052706L;
    private SerializablePredicate<? super R> filterFn;
    private OutputCollector collector;

    public FilterOperator(SerializablePredicate<? super R> filterFn) {
        this.filterFn = filterFn;
    }

    public void prepare(Map map, TopologyContext topologyContext, OutputCollector outputCollector) {
        this.collector = outputCollector;
    }

    @Override
    public void execute(Tuple tuple) {
        Object obj = tuple.getValue(0);
        if (this.filterFn.test(obj)) {
            this.collector.emit(new Values(obj));
        }
        this.collector.ack(tuple);
    }
}

