/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.SerializablePredicate;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.operators.FilterOperator;

public class FilterStreamlet<R>
extends StreamletImpl<R> {
    private StreamletImpl<R> parent;
    private SerializablePredicate<? super R> filterFn;

    public FilterStreamlet(StreamletImpl<R> parent, SerializablePredicate<? super R> filterFn) {
        this.parent = parent;
        this.filterFn = filterFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.FILTER, stageNames);
        bldr.setBolt(this.getName(), new FilterOperator<R>(this.filterFn), (Number)this.getNumPartitions()).shuffleGrouping(this.parent.getName());
        return true;
    }
}

