/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.KeyedWindow;
import org.apache.heron.streamlet.SerializableBiFunction;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.WindowConfig;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.WindowConfigImpl;
import org.apache.heron.streamlet.impl.groupings.ReduceByKeyAndWindowCustomGrouping;
import org.apache.heron.streamlet.impl.operators.GeneralReduceByKeyAndWindowOperator;

public class GeneralReduceByKeyAndWindowStreamlet<K, V, VR>
extends StreamletImpl<KeyValue<KeyedWindow<K>, VR>> {
    private StreamletImpl<V> parent;
    private SerializableFunction<V, K> keyExtractor;
    private WindowConfigImpl windowCfg;
    private VR identity;
    private SerializableBiFunction<VR, V, ? extends VR> reduceFn;

    public GeneralReduceByKeyAndWindowStreamlet(StreamletImpl<V> parent, SerializableFunction<V, K> keyExtractor, WindowConfig windowCfg, VR identity, SerializableBiFunction<VR, V, ? extends VR> reduceFn) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.windowCfg = (WindowConfigImpl)windowCfg;
        this.identity = identity;
        this.reduceFn = reduceFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.REDUCE, stageNames);
        GeneralReduceByKeyAndWindowOperator<K, V, ? extends VR> bolt = new GeneralReduceByKeyAndWindowOperator<K, V, VR>(this.keyExtractor, this.identity, this.reduceFn);
        this.windowCfg.attachWindowConfig(bolt);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), new ReduceByKeyAndWindowCustomGrouping<K, V>(this.keyExtractor));
        return true;
    }
}

