/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.JoinType;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.KeyedWindow;
import org.apache.heron.streamlet.SerializableBiFunction;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.WindowConfig;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.WindowConfigImpl;
import org.apache.heron.streamlet.impl.groupings.JoinCustomGrouping;
import org.apache.heron.streamlet.impl.operators.JoinOperator;

public final class JoinStreamlet<K, R, S, T>
extends StreamletImpl<KeyValue<KeyedWindow<K>, T>> {
    private JoinType joinType;
    private StreamletImpl<R> left;
    private StreamletImpl<S> right;
    private SerializableFunction<R, K> leftKeyExtractor;
    private SerializableFunction<S, K> rightKeyExtractor;
    private WindowConfigImpl windowCfg;
    private SerializableBiFunction<R, S, ? extends T> joinFn;

    public static <A, B, C, D> JoinStreamlet<A, B, C, D> createJoinStreamlet(StreamletImpl<B> left, StreamletImpl<C> right, SerializableFunction<B, A> leftKeyExtractor, SerializableFunction<C, A> rightKeyExtractor, WindowConfig windowCfg, JoinType joinType, SerializableBiFunction<B, C, ? extends D> joinFn) {
        return new JoinStreamlet<A, B, C, D>(joinType, left, right, leftKeyExtractor, rightKeyExtractor, windowCfg, joinFn);
    }

    private JoinStreamlet(JoinType joinType, StreamletImpl<R> left, StreamletImpl<S> right, SerializableFunction<R, K> leftKeyExtractor, SerializableFunction<S, K> rightKeyExtractor, WindowConfig windowCfg, SerializableBiFunction<R, S, ? extends T> joinFn) {
        this.joinType = joinType;
        this.left = left;
        this.right = right;
        this.leftKeyExtractor = leftKeyExtractor;
        this.rightKeyExtractor = rightKeyExtractor;
        this.windowCfg = (WindowConfigImpl)windowCfg;
        this.joinFn = joinFn;
        this.setNumPartitions(left.getNumPartitions());
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        if (!this.left.isBuilt() || !this.right.isBuilt()) {
            return false;
        }
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.JOIN, stageNames);
        JoinOperator<K, R, S, ? extends T> bolt = new JoinOperator<K, R, S, T>(this.joinType, this.left.getName(), this.right.getName(), this.leftKeyExtractor, this.rightKeyExtractor, this.joinFn);
        this.windowCfg.attachWindowConfig(bolt);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.left.getName(), new JoinCustomGrouping<K, R>(this.leftKeyExtractor)).customGrouping(this.right.getName(), new JoinCustomGrouping<K, S>(this.rightKeyExtractor));
        return true;
    }
}

