/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.KeyedWindow;
import org.apache.heron.streamlet.SerializableBinaryOperator;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.WindowConfig;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.WindowConfigImpl;
import org.apache.heron.streamlet.impl.groupings.ReduceByKeyAndWindowCustomGrouping;
import org.apache.heron.streamlet.impl.operators.ReduceByKeyAndWindowOperator;

public class ReduceByKeyAndWindowStreamlet<K, V, R>
extends StreamletImpl<KeyValue<KeyedWindow<K>, V>> {
    private StreamletImpl<R> parent;
    private SerializableFunction<R, K> keyExtractor;
    private SerializableFunction<R, V> valueExtractor;
    private WindowConfigImpl windowCfg;
    private SerializableBinaryOperator<V> reduceFn;

    public ReduceByKeyAndWindowStreamlet(StreamletImpl<R> parent, SerializableFunction<R, K> keyExtractor, SerializableFunction<R, V> valueExtractor, WindowConfig windowCfg, SerializableBinaryOperator<V> reduceFn) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.valueExtractor = valueExtractor;
        this.windowCfg = (WindowConfigImpl)windowCfg;
        this.reduceFn = reduceFn;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.REDUCE, stageNames);
        ReduceByKeyAndWindowOperator<K, V, R> bolt = new ReduceByKeyAndWindowOperator<K, V, R>(this.keyExtractor, this.valueExtractor, this.reduceFn);
        this.windowCfg.attachWindowConfig(bolt);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), new ReduceByKeyAndWindowCustomGrouping<K, R>(this.keyExtractor));
        return true;
    }
}

