/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.SerializableTransformer;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.operators.TransformOperator;

public class TransformStreamlet<R, T>
extends StreamletImpl<T> {
    private StreamletImpl<R> parent;
    private SerializableTransformer<? super R, ? extends T> serializableTransformer;

    public TransformStreamlet(StreamletImpl<R> parent, SerializableTransformer<? super R, ? extends T> serializableTransformer) {
        this.parent = parent;
        this.serializableTransformer = serializableTransformer;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.TRANSFORM, stageNames);
        bldr.setBolt(this.getName(), new TransformOperator<R, T>(this.serializableTransformer), (Number)this.getNumPartitions()).shuffleGrouping(this.parent.getName());
        return true;
    }
}

