/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.heron.api.serializer.IPluggableSerializer;

public class KryoSerializer
implements IPluggableSerializer {
    private Kryo kryo;
    private Output kryoOut;
    private Input kryoIn;

    public static void checkForKryo() {
        Kryo k = new Kryo();
    }

    @Override
    public void initialize(Map<String, Object> config) {
        this.kryo = this.getKryo();
        this.kryoOut = new Output(2000, 2000000000);
        this.kryoIn = new Input(1);
    }

    @Override
    public byte[] serialize(Object object) {
        this.kryoOut.clear();
        this.kryo.writeClassAndObject(this.kryoOut, object);
        return this.kryoOut.toBytes();
    }

    @Override
    public Object deserialize(byte[] input) {
        this.kryoIn.setBuffer(input);
        return this.kryo.readClassAndObject(this.kryoIn);
    }

    private Kryo getKryo() {
        Kryo k = new Kryo();
        k.setRegistrationRequired(false);
        k.setReferences(false);
        k.register(byte[].class);
        k.register(ArrayList.class, (Serializer)new ArrayListSerializer());
        k.register(HashMap.class, (Serializer)new HashMapSerializer());
        k.register(HashSet.class, (Serializer)new HashSetSerializer());
        k.register(BigInteger.class, (Serializer)new DefaultSerializers.BigIntegerSerializer());
        return k;
    }

    private class HashSetSerializer
    extends CollectionSerializer {
        private HashSetSerializer() {
        }

        public Collection create(Kryo k, Input input, Class<Collection> type) {
            return new HashSet();
        }
    }

    private class HashMapSerializer
    extends MapSerializer {
        private HashMapSerializer() {
        }

        public Map<String, Object> create(Kryo k, Input input, Class<Map> type) {
            return new HashMap<String, Object>();
        }
    }

    private class ArrayListSerializer
    extends CollectionSerializer {
        private ArrayListSerializer() {
        }

        public Collection create(Kryo k, Input input, Class<Collection> type) {
            return new ArrayList();
        }
    }
}

