/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.bolt;

import java.util.Map;
import java.util.logging.Logger;
import org.apache.heron.api.bolt.BasicOutputCollector;
import org.apache.heron.api.bolt.IBasicBolt;
import org.apache.heron.api.bolt.IRichBolt;
import org.apache.heron.api.bolt.OutputCollector;
import org.apache.heron.api.exception.FailedException;
import org.apache.heron.api.exception.ReportedFailedException;
import org.apache.heron.api.topology.IUpdatable;
import org.apache.heron.api.topology.OutputFieldsDeclarer;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Tuple;

public class BasicBoltExecutor
implements IRichBolt,
IUpdatable {
    private static final Logger LOG = Logger.getLogger(BasicBoltExecutor.class.getName());
    private static final long serialVersionUID = 7021447981762957626L;
    private IBasicBolt bolt;
    private transient BasicOutputCollector collector;

    public BasicBoltExecutor(IBasicBolt aBolt) {
        this.bolt = aBolt;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this.bolt.declareOutputFields(declarer);
    }

    @Override
    public void prepare(Map<String, Object> heronConf, TopologyContext context, OutputCollector aCollector) {
        this.bolt.prepare(heronConf, context);
        this.collector = new BasicOutputCollector(aCollector);
    }

    @Override
    public void execute(Tuple input) {
        this.collector.setContext(input);
        try {
            this.bolt.execute(input, this.collector);
            this.collector.getOutputter().ack(input);
        }
        catch (FailedException e) {
            if (e instanceof ReportedFailedException) {
                this.collector.reportError(e);
            }
            this.collector.getOutputter().fail(input);
        }
    }

    @Override
    public void cleanup() {
        this.bolt.cleanup();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.bolt.getComponentConfiguration();
    }

    @Override
    public void update(TopologyContext topologyContext) {
        if (this.bolt instanceof IUpdatable) {
            ((IUpdatable)((Object)this.bolt)).update(topologyContext);
        } else {
            LOG.warning(String.format("Update() event received but can not call update() on delegate because it does not implement %s: %s", IUpdatable.class.getName(), this.bolt));
        }
    }
}

