/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtils {
    private static final Logger LOG = Logger.getLogger(FileUtils.class.getName());

    private FileUtils() {
    }

    public static boolean deleteFile(String filename) {
        Path file = new File(filename).toPath();
        try {
            Files.delete(file);
        }
        catch (NoSuchFileException x) {
            LOG.severe("file does not exist: " + file);
            return false;
        }
        catch (DirectoryNotEmptyException x) {
            LOG.severe("Path is an not empty directory: " + file);
            return false;
        }
        catch (IOException x) {
            LOG.log(Level.SEVERE, "Failed to delete file due to unexpected exception:", x);
            return false;
        }
        return true;
    }

    public static boolean copyFile(String source, String target) {
        Path sourcePath = new File(source).toPath();
        Path targetPath = new File(target).toPath();
        try {
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to copy file from " + source + " to target: " + target, e);
            return false;
        }
        return true;
    }

    public static boolean writeToFile(String filename, byte[] contents, boolean overwrite) {
        OpenOption[] openOptionArray;
        if (overwrite) {
            openOptionArray = new OpenOption[]{};
        } else {
            OpenOption[] openOptionArray2 = new OpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.CREATE_NEW;
        }
        OpenOption[] options = openOptionArray;
        try {
            Files.write(new File(filename).toPath(), contents, options);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to write content to file. ", e);
            return false;
        }
        return true;
    }

    public static byte[] readFromFile(String filename) {
        byte[] res;
        Path path = new File(filename).toPath();
        try {
            res = Files.readAllBytes(path);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to read from file. ", e);
            res = new byte[]{};
        }
        return res;
    }

    public static boolean createDirectory(String directory) {
        return new File(directory).mkdirs();
    }

    public static boolean isDirectoryExists(String directory) {
        return Files.isDirectory(new File(directory).toPath(), new LinkOption[0]);
    }

    public static boolean isFileExists(String file) {
        return Files.exists(new File(file).toPath(), new LinkOption[0]);
    }

    public static boolean hasChildren(String file) {
        return FileUtils.isDirectoryExists(file) && new File(file).list().length > 0;
    }

    public static String getBaseName(String file) {
        return new File(file).getName();
    }

    public static boolean deleteDir(String dir) {
        return FileUtils.deleteDir(new File(dir), true);
    }

    public static boolean deleteDir(File dir, boolean deleteSelf) {
        if (Files.isSymbolicLink(dir.toPath())) {
            try {
                Files.delete(dir.toPath());
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        if (dir.isDirectory()) {
            String[] children;
            for (String child : children = dir.list()) {
                boolean success = FileUtils.deleteDir(new File(dir, child), true);
                if (success) continue;
                return false;
            }
        }
        if (deleteSelf) {
            return dir.delete();
        }
        return true;
    }

    public static boolean cleanDir(String dir) {
        return FileUtils.deleteDir(new File(dir), false);
    }
}

