/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.time.Duration;
import java.util.Iterator;
import java.util.Set;
import org.apache.heron.common.basics.ISelectHandler;
import org.apache.heron.common.basics.WakeableLooper;

public class NIOLooper
extends WakeableLooper {
    private final Selector selector = Selector.open();

    public NIOLooper() throws IOException {
        this.addNIOLooperTasks();
    }

    private void addNIOLooperTasks() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NIOLooper.this.handleSelectedKeys();
            }
        };
        this.addTasksOnWakeup(task);
    }

    @Override
    public void doWait() {
        Duration nextTimeoutInterval = this.getNextTimeoutInterval();
        try {
            if (nextTimeoutInterval.toMillis() > 0L) {
                this.selector.select(nextTimeoutInterval.toMillis());
            } else {
                this.selector.selectNow();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void wakeUp() {
        this.selector.wakeup();
    }

    public void removeAllInterest(SelectableChannel channel) {
        SelectionKey key = channel.keyFor(this.selector);
        if (key != null) {
            key.cancel();
        }
    }

    private void handleSelectedKeys() {
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        Iterator<SelectionKey> keyIterator = selectedKeys.iterator();
        while (keyIterator.hasNext()) {
            SelectionKey key = keyIterator.next();
            keyIterator.remove();
            ISelectHandler callback = (ISelectHandler)key.attachment();
            if (!key.isValid()) {
                callback.handleError(key.channel());
                continue;
            }
            if (key.isValid() && key.isWritable()) {
                callback.handleWrite(key.channel());
            }
            if (key.isValid() && key.isReadable()) {
                callback.handleRead(key.channel());
            }
            if (key.isValid() && key.isConnectable()) {
                callback.handleConnect(key.channel());
            }
            if (!key.isValid() || !key.isAcceptable()) continue;
            callback.handleAccept(key.channel());
        }
    }

    public boolean isChannelValid(SelectableChannel channel) {
        SelectionKey key = channel.keyFor(this.selector);
        return key != null && key.isValid();
    }

    public void registerRead(SelectableChannel channel, ISelectHandler callback) throws ClosedChannelException {
        assert (channel.keyFor(this.selector) == null || (channel.keyFor(this.selector).interestOps() & 8) == 0);
        this.addInterest(channel, 1, callback);
    }

    public void unregisterRead(SelectableChannel channel) {
        this.removeInterest(channel, 1);
    }

    public boolean isReadRegistered(SelectableChannel channel) {
        return this.isInterestRegistered(channel, 1);
    }

    public void registerConnect(SelectableChannel channel, ISelectHandler callback) throws ClosedChannelException {
        assert (channel.keyFor(this.selector) == null);
        this.addInterest(channel, 8, callback);
    }

    public void unregisterConnect(SelectableChannel channel) {
        this.removeInterest(channel, 8);
    }

    public boolean isConnectRegistered(SelectableChannel channel) {
        return this.isInterestRegistered(channel, 8);
    }

    public void registerAccept(SelectableChannel channel, ISelectHandler callback) throws ClosedChannelException {
        this.addInterest(channel, 16, callback);
    }

    public void unregisterAccept(SelectableChannel channel) {
        this.removeInterest(channel, 16);
    }

    public boolean isAcceptRegistered(SelectableChannel channel) {
        return this.isInterestRegistered(channel, 16);
    }

    public void registerWrite(SelectableChannel channel, ISelectHandler callback) throws ClosedChannelException {
        this.addInterest(channel, 4, callback);
    }

    public void unregisterWrite(SelectableChannel channel) {
        this.removeInterest(channel, 4);
    }

    public boolean isWriteRegistered(SelectableChannel channel) {
        return this.isInterestRegistered(channel, 4);
    }

    private void addInterest(SelectableChannel channel, int operation, ISelectHandler callback) throws ClosedChannelException {
        SelectionKey key = channel.keyFor(this.selector);
        if (key == null) {
            channel.register(this.selector, operation, callback);
        } else {
            if (!key.isValid()) {
                throw new RuntimeException(String.format("Unable to add %d in %s due to key is invalid", operation, channel));
            }
            if ((key.interestOps() & operation) != 0) {
                throw new RuntimeException(String.format("%d has been registered in %s", operation, channel));
            }
            if (key.attachment() == null) {
                key.attach(callback);
            } else if (callback != key.attachment()) {
                throw new RuntimeException("Unmatched SelectHandler has already been attached for other operation");
            }
            key.interestOps(key.interestOps() | operation);
        }
    }

    private void removeInterest(SelectableChannel channel, int operation) {
        SelectionKey key = channel.keyFor(this.selector);
        key.interestOps(key.interestOps() & ~operation);
    }

    private boolean isInterestRegistered(SelectableChannel channel, int operation) {
        SelectionKey key = channel.keyFor(this.selector);
        return key != null && (key.interestOps() & operation) != 0;
    }
}

