/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

public abstract class ResourceMeasure<V extends Number>
implements Comparable<ResourceMeasure<V>> {
    protected final V value;

    protected ResourceMeasure(V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    public V getValue() {
        return this.value;
    }

    public boolean isZero() {
        return ((Number)this.value).doubleValue() == 0.0;
    }

    public abstract ResourceMeasure<V> minus(ResourceMeasure<V> var1);

    public abstract ResourceMeasure<V> plus(ResourceMeasure<V> var1);

    public abstract ResourceMeasure<V> multiply(int var1);

    public abstract ResourceMeasure<V> divide(int var1);

    public abstract ResourceMeasure<V> increaseBy(int var1);

    public boolean greaterThan(ResourceMeasure<V> other) {
        return ((Comparable)this.value).compareTo(other.value) > 0;
    }

    public boolean greaterOrEqual(ResourceMeasure<V> other) {
        return ((Comparable)this.value).compareTo(other.value) >= 0;
    }

    public boolean lessThan(ResourceMeasure<V> other) {
        return ((Comparable)this.value).compareTo(other.value) < 0;
    }

    public boolean lessOrEqual(ResourceMeasure<V> other) {
        return ((Comparable)this.value).compareTo(other.value) <= 0;
    }

    @Override
    public int compareTo(ResourceMeasure<V> o) {
        return ((Comparable)this.value).compareTo(o.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResourceMeasure that = (ResourceMeasure)other;
        return this.value.equals(that.value);
    }
}

