/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.operators;

import java.util.List;
import java.util.Map;
import org.apache.heron.api.topology.OutputFieldsDeclarer;
import org.apache.heron.api.tuple.Fields;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.api.tuple.Values;
import org.apache.heron.streamlet.SerializablePredicate;
import org.apache.heron.streamlet.impl.operators.StreamletOperator;

public class SplitOperator<R>
extends StreamletOperator<R, R> {
    private Map<String, SerializablePredicate<R>> splitFns;

    public SplitOperator(Map<String, SerializablePredicate<R>> splitFns) {
        this.splitFns = splitFns;
    }

    @Override
    public void execute(Tuple tuple) {
        Object obj = tuple.getValue(0);
        for (Map.Entry<String, SerializablePredicate<R>> entry : this.splitFns.entrySet()) {
            if (!entry.getValue().test(obj)) continue;
            this.collector.emit(entry.getKey(), (List<Object>)new Values(obj));
        }
        this.collector.ack(tuple);
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (String stream : this.splitFns.keySet()) {
            declarer.declareStream(stream, new Fields("output"));
        }
    }
}

