/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Map;
import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.SerializablePredicate;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.operators.SplitOperator;

public class SplitStreamlet<R>
extends StreamletImpl<R> {
    private StreamletImpl<R> parent;
    private Map<String, SerializablePredicate<R>> splitFns;

    public SplitStreamlet(StreamletImpl<R> parent, Map<String, SerializablePredicate<R>> splitFns) {
        this.parent = parent;
        this.splitFns = splitFns;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    protected Set<String> getAvailableStreamIds() {
        return this.splitFns.keySet();
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.SPLIT, stageNames);
        bldr.setBolt(this.getName(), new SplitOperator<R>(this.splitFns), (Number)this.getNumPartitions()).shuffleGrouping(this.parent.getName(), this.parent.getStreamId());
        return true;
    }
}

