/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.operators;

import java.io.Serializable;
import java.util.Map;
import org.apache.heron.api.bolt.OutputCollector;
import org.apache.heron.api.state.State;
import org.apache.heron.api.topology.IStatefulComponent;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.api.tuple.Values;
import org.apache.heron.streamlet.SerializableTransformer;
import org.apache.heron.streamlet.impl.ContextImpl;
import org.apache.heron.streamlet.impl.operators.StreamletOperator;

public class TransformOperator<R, T>
extends StreamletOperator<R, T>
implements IStatefulComponent<Serializable, Serializable> {
    private static final long serialVersionUID = 429297144878185182L;
    private SerializableTransformer<? super R, ? extends T> serializableTransformer;
    private State<Serializable, Serializable> state;

    public TransformOperator(SerializableTransformer<? super R, ? extends T> serializableTransformer) {
        this.serializableTransformer = serializableTransformer;
    }

    @Override
    public void initState(State<Serializable, Serializable> startupState) {
        this.state = startupState;
    }

    @Override
    public void preSave(String checkpointId) {
    }

    @Override
    public void cleanup() {
        this.serializableTransformer.cleanup();
    }

    @Override
    public void prepare(Map<String, Object> map, TopologyContext topologyContext, OutputCollector outputCollector) {
        super.prepare(map, topologyContext, outputCollector);
        ContextImpl context = new ContextImpl(topologyContext, map, this.state);
        this.serializableTransformer.setup(context);
    }

    @Override
    public void execute(Tuple tuple) {
        Object obj = tuple.getValue(0);
        this.serializableTransformer.transform(obj, x -> this.collector.emit(new Values(x)));
        this.collector.ack(tuple);
    }
}

