/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet;

import java.io.Serializable;
import org.apache.heron.api.Config;
import org.apache.heron.api.serializer.JavaSerializer;
import org.apache.heron.api.serializer.KryoSerializer;
import org.apache.heron.common.basics.ByteAmount;

public final class Config
implements Serializable {
    private static final long serialVersionUID = 6204498077403076352L;
    private org.apache.heron.api.Config heronConfig;
    private final double cpu;
    private final ByteAmount ram;
    private final DeliverySemantics deliverySemantics;
    private final Serializer serializer;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;

    private Config(Builder builder) {
        this.heronConfig = builder.config;
        this.cpu = builder.cpu;
        this.ram = builder.ram;
        this.serializer = builder.serializer;
        this.deliverySemantics = builder.deliverySemantics;
    }

    public static Config defaultConfig() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public org.apache.heron.api.Config getHeronConfig() {
        return this.heronConfig;
    }

    public double getPerContainerCpu() {
        return this.cpu;
    }

    public long getPerContainerRam() {
        return this.getPerContainerRamAsBytes();
    }

    public long getPerContainerRamAsBytes() {
        return this.ram.asBytes();
    }

    public long getPerContainerRamAsMegabytes() {
        return this.ram.asMegabytes();
    }

    public long getPerContainerRamAsGigabytes() {
        return this.ram.asGigabytes();
    }

    public DeliverySemantics getDeliverySemantics() {
        return this.deliverySemantics;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    private static Config.TopologyReliabilityMode translateSemantics(DeliverySemantics semantics) {
        switch (semantics) {
            case ATMOST_ONCE: {
                return Config.TopologyReliabilityMode.ATMOST_ONCE;
            }
            case ATLEAST_ONCE: {
                return Config.TopologyReliabilityMode.ATLEAST_ONCE;
            }
            case EFFECTIVELY_ONCE: {
                return Config.TopologyReliabilityMode.EFFECTIVELY_ONCE;
            }
        }
        return Config.TopologyReliabilityMode.ATMOST_ONCE;
    }

    private static String translateSerializer(Serializer serializer) {
        switch (serializer) {
            case JAVA: {
                return JavaSerializer.class.getName();
            }
            case KRYO: {
                return KryoSerializer.class.getName();
            }
        }
        return KryoSerializer.class.getName();
    }

    public static final class Builder {
        private org.apache.heron.api.Config config = new org.apache.heron.api.Config();
        private double cpu = -1.0;
        private ByteAmount ram = Defaults.RAM;
        private DeliverySemantics deliverySemantics = Defaults.SEMANTICS;
        private Serializer serializer = Defaults.SERIALIZER;

        private Builder() {
        }

        public Builder setPerContainerCpu(double perContainerCpu) {
            this.cpu = perContainerCpu;
            this.config.setContainerCpuRequested(perContainerCpu);
            this.config.setContainerMaxCpuHint(perContainerCpu);
            return this;
        }

        public Builder setPerContainerRam(long perContainerRam) {
            return this.setPerContainerRamInBytes(perContainerRam);
        }

        public Builder setPerContainerRamInBytes(long perContainerRam) {
            this.ram = ByteAmount.fromBytes(perContainerRam);
            this.config.setContainerRamRequested(this.ram);
            this.config.setContainerMaxRamHint(this.ram);
            return this;
        }

        public Builder setPerContainerRamInMegabytes(long perContainerRamMB) {
            return this.setPerContainerRam(perContainerRamMB * 0x100000L);
        }

        public Builder setPerContainerRamInGigabytes(long perContainerRamGB) {
            return this.setPerContainerRam(perContainerRamGB * 0x40000000L);
        }

        public Builder setNumContainers(int numContainers) {
            this.config.setNumStmgrs(numContainers);
            return this;
        }

        public Builder setDeliverySemantics(DeliverySemantics semantics) {
            this.deliverySemantics = semantics;
            return this;
        }

        private void applyDeliverySemantics() {
            this.config.setTopologyReliabilityMode(Config.translateSemantics(this.deliverySemantics));
        }

        public Builder setUserConfig(String key, Object value) {
            this.config.put(key, value);
            return this;
        }

        public Builder setSerializer(Serializer topologySerializer) {
            this.serializer = topologySerializer;
            return this;
        }

        private void applySerializer() {
            try {
                String serializerClass = Config.translateSerializer(this.serializer);
                this.config.setSerializationClassName(serializerClass);
            }
            catch (NoClassDefFoundError e) {
                throw new RuntimeException("Linking with serializer" + (Object)((Object)this.serializer) + " is needed");
            }
        }

        public Config build() {
            this.applySerializer();
            this.applyDeliverySemantics();
            return new Config(this);
        }
    }

    private static class Defaults {
        static final double CPU = -1.0;
        static final ByteAmount RAM = ByteAmount.fromBytes(-1L);
        static final DeliverySemantics SEMANTICS = DeliverySemantics.ATMOST_ONCE;
        static final Serializer SERIALIZER = Serializer.KRYO;

        private Defaults() {
        }
    }

    public static enum Serializer {
        JAVA,
        KRYO;

    }

    public static enum DeliverySemantics {
        ATMOST_ONCE,
        ATLEAST_ONCE,
        EFFECTIVELY_ONCE;

    }
}

