/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.basics;

import java.util.HashMap;
import java.util.Map;
import org.apache.heron.common.basics.ResourceMeasure;

public final class CPUShare
extends ResourceMeasure<Double> {
    private CPUShare(Double value) {
        super(value);
    }

    public static CPUShare fromDouble(double value) {
        return new CPUShare(value);
    }

    public CPUShare minus(ResourceMeasure<Double> other) {
        return new CPUShare((Double)this.value - (Double)other.value);
    }

    public CPUShare plus(ResourceMeasure<Double> other) {
        return new CPUShare((Double)this.value + (Double)other.value);
    }

    public CPUShare multiply(int factor) {
        return new CPUShare((Double)this.value * (double)factor);
    }

    public CPUShare divide(int factor) {
        return new CPUShare((Double)this.value / (double)factor);
    }

    public CPUShare increaseBy(int percentage) {
        return new CPUShare((Double)this.value * (1.0 + (double)percentage / 100.0));
    }

    public static Map<String, CPUShare> convertDoubleMapToCpuShareMap(Map<String, Double> doubleMap) {
        HashMap<String, CPUShare> retval = new HashMap<String, CPUShare>();
        for (Map.Entry<String, Double> entry : doubleMap.entrySet()) {
            retval.put(entry.getKey(), new CPUShare(entry.getValue()));
        }
        return retval;
    }

    public String toString() {
        return String.format("CPUShare{%.3f}", this.value);
    }
}

