/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.StreamletBase;
import org.apache.heron.streamlet.impl.utils.StreamletUtils;

public abstract class StreamletBaseImpl<R>
implements StreamletBase<R> {
    private static final Logger LOG = Logger.getLogger(StreamletBaseImpl.class.getName());
    protected String name = null;
    protected int nPartitions = -1;
    private List<StreamletBaseImpl<?>> children = new LinkedList();
    private boolean built = false;

    protected StreamletBaseImpl() {
    }

    @Override
    public StreamletBase<R> setName(String sName) {
        StreamletUtils.checkNotBlank(sName, "Streamlet name cannot be null/blank");
        this.name = sName;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private String defaultNameCalculator(StreamletNamePrefix prefix, Set<String> stageNames) {
        String calculatedName;
        int index = 1;
        while (stageNames.contains(calculatedName = prefix.toString() + index)) {
            ++index;
        }
        LOG.info("Calculated stage Name as " + calculatedName);
        return calculatedName;
    }

    protected void setDefaultNameIfNone(StreamletNamePrefix prefix, Set<String> stageNames) {
        if (this.getName() == null) {
            this.setName(this.defaultNameCalculator(prefix, stageNames));
        }
        if (stageNames.contains(this.getName())) {
            throw new RuntimeException(String.format("The stage name %s is used multiple times in the same topology", this.getName()));
        }
        stageNames.add(this.getName());
    }

    @Override
    public StreamletBase<R> setNumPartitions(int numPartitions) {
        StreamletUtils.require(numPartitions > 0, "Streamlet's partitions number should be > 0");
        this.nPartitions = numPartitions;
        return this;
    }

    @Override
    public int getNumPartitions() {
        return this.nPartitions;
    }

    public <T> void addChild(StreamletBaseImpl<T> child) {
        this.children.add(child);
    }

    public List<StreamletBaseImpl<?>> getChildren() {
        return this.children;
    }

    public void build(TopologyBuilder bldr, Set<String> stageNames) {
        if (this.built) {
            throw new RuntimeException("Logic Error While building " + this.getName());
        }
        if (this.doBuild(bldr, stageNames)) {
            this.built = true;
            for (StreamletBaseImpl<?> streamlet : this.getChildren()) {
                streamlet.build(bldr, stageNames);
            }
        }
    }

    public boolean isBuilt() {
        return this.built;
    }

    public boolean isFullyBuilt() {
        if (!this.isBuilt()) {
            return false;
        }
        for (StreamletBaseImpl<?> child : this.children) {
            if (child.isFullyBuilt()) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean doBuild(TopologyBuilder var1, Set<String> var2);

    protected static enum StreamletNamePrefix {
        CONSUMER("consumer"),
        COUNT("count"),
        CUSTOM("custom"),
        CUSTOM_BASIC("customBasic"),
        CUSTOM_WINDOW("customWindow"),
        FILTER("filter"),
        FLATMAP("flatmap"),
        JOIN("join"),
        KEYBY("keyBy"),
        LOGGER("logger"),
        MAP("map"),
        SOURCE("generator"),
        REDUCE("reduce"),
        REMAP("remap"),
        SINK("sink"),
        SPLIT("split"),
        SPOUT("spout"),
        SUPPLIER("supplier"),
        TRANSFORM("transform"),
        UNION("union");

        private final String prefix;

        private StreamletNamePrefix(String prefix) {
            this.prefix = prefix;
        }

        public String toString() {
            return this.prefix;
        }
    }
}

