/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.streamlet.impl.streamlets;

import java.util.Set;
import org.apache.heron.api.topology.TopologyBuilder;
import org.apache.heron.streamlet.KeyValue;
import org.apache.heron.streamlet.KeyedWindow;
import org.apache.heron.streamlet.SerializableFunction;
import org.apache.heron.streamlet.StreamletReducers;
import org.apache.heron.streamlet.WindowConfig;
import org.apache.heron.streamlet.impl.StreamletImpl;
import org.apache.heron.streamlet.impl.groupings.ReduceByKeyAndWindowCustomGrouping;
import org.apache.heron.streamlet.impl.operators.ReduceByKeyAndWindowOperator;

public class CountByKeyAndWindowStreamlet<R, K>
extends StreamletImpl<KeyValue<KeyedWindow<K>, Long>> {
    private StreamletImpl<R> parent;
    private SerializableFunction<R, K> keyExtractor;
    private WindowConfig windowCfg;

    public CountByKeyAndWindowStreamlet(StreamletImpl<R> parent, SerializableFunction<R, K> keyExtractor, WindowConfig windowCfg) {
        this.parent = parent;
        this.keyExtractor = keyExtractor;
        this.windowCfg = windowCfg;
        this.setNumPartitions(parent.getNumPartitions());
    }

    @Override
    public boolean doBuild(TopologyBuilder bldr, Set<String> stageNames) {
        this.setDefaultNameIfNone(StreamletImpl.StreamletNamePrefix.COUNT, stageNames);
        ReduceByKeyAndWindowOperator bolt = new ReduceByKeyAndWindowOperator(this.keyExtractor, x -> 1L, StreamletReducers::sum);
        this.windowCfg.applyTo(bolt);
        bldr.setBolt(this.getName(), bolt, (Number)this.getNumPartitions()).customGrouping(this.parent.getName(), this.parent.getStreamId(), new ReduceByKeyAndWindowCustomGrouping<R, K>(this.keyExtractor));
        return true;
    }
}

