/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.common.basics.ISelectHandler;
import org.apache.heron.common.basics.NIOLooper;
import org.apache.heron.common.network.HeronSocketOptions;
import org.apache.heron.common.network.IncomingPacket;
import org.apache.heron.common.network.OutgoingPacket;
import org.apache.heron.common.network.REQID;
import org.apache.heron.common.network.SocketChannelHelper;
import org.apache.heron.common.network.StatusCode;
import org.apache.heron.shaded.com.google.protobuf.Message;

public abstract class HeronClient
implements ISelectHandler {
    private static final Logger LOG = Logger.getLogger(HeronClient.class.getName());
    protected Map<REQID, Object> contextMap;
    protected Map<REQID, Message.Builder> responseMessageMap;
    protected Map<String, Message.Builder> messageMap;
    private SocketChannel socketChannel;
    private InetSocketAddress endpoint;
    private NIOLooper nioLooper;
    private SocketChannelHelper socketChannelHelper;
    private HeronSocketOptions socketOptions;
    private boolean isConnected;

    public HeronClient(NIOLooper s, String host, int port, HeronSocketOptions options) {
        this.nioLooper = s;
        this.endpoint = new InetSocketAddress(host, port);
        this.socketOptions = options;
        this.isConnected = false;
        this.contextMap = new HashMap<REQID, Object>();
        this.responseMessageMap = new HashMap<REQID, Message.Builder>();
        this.messageMap = new HashMap<String, Message.Builder>();
    }

    public void registerOnMessage(Message.Builder builder) {
        this.messageMap.put(builder.getDescriptorForType().getFullName(), builder);
    }

    public void start() {
        try {
            this.socketChannel = SocketChannel.open();
            this.socketChannel.configureBlocking(false);
            this.socketChannel.socket().setSendBufferSize((int)this.socketOptions.getSocketSendBufferSize().asBytes());
            this.socketChannel.socket().setReceiveBufferSize((int)this.socketOptions.getSocketReceivedBufferSize().asBytes());
            this.socketChannel.socket().setTcpNoDelay(true);
            LOG.info("Connecting to endpoint: " + this.endpoint);
            if (this.socketChannel.connect(this.endpoint)) {
                this.handleConnect(this.socketChannel);
            } else {
                this.nioLooper.registerConnect(this.socketChannel, this);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error connecting to remote endpoint: " + this.endpoint, e);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    HeronClient.this.onConnect(StatusCode.CONNECT_ERROR);
                }
            };
            this.nioLooper.registerTimerEvent(Duration.ZERO, r);
        }
    }

    public void stop() {
        if (!this.isConnected()) {
            return;
        }
        this.forceFlushWithBestEffort();
        LOG.info("To stop the HeronClient.");
        this.contextMap.clear();
        this.responseMessageMap.clear();
        this.messageMap.clear();
        this.socketChannelHelper.clear();
        this.nioLooper.removeAllInterest(this.socketChannel);
        try {
            this.socketChannel.close();
            this.onClose();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to stop Client", e);
        }
    }

    @Override
    public void handleRead(SelectableChannel channel) {
        List<IncomingPacket> packets = this.socketChannelHelper.read();
        for (IncomingPacket ipt : packets) {
            this.handlePacket(ipt);
        }
    }

    @Override
    public void handleWrite(SelectableChannel channel) {
        this.socketChannelHelper.write();
    }

    public void sendRequest(Message request, Object context, Message.Builder responseBuilder, Duration timeout) {
        final REQID rid = REQID.generate();
        this.contextMap.put(rid, context);
        this.responseMessageMap.put(rid, responseBuilder);
        if (timeout.getSeconds() > 0L) {
            this.registerTimerEvent(timeout, new Runnable(){

                @Override
                public void run() {
                    HeronClient.this.handleTimeout(rid);
                }
            });
        }
        OutgoingPacket opk = new OutgoingPacket(rid, request);
        this.socketChannelHelper.sendPacket(opk);
    }

    public void sendRequest(Message request, Message.Builder responseBuilder) {
        this.sendRequest(request, null, responseBuilder, Duration.ZERO);
    }

    public void sendMessage(Message message) {
        OutgoingPacket opk = new OutgoingPacket(REQID.zeroREQID, message);
        this.socketChannelHelper.sendPacket(opk);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public NIOLooper getNIOLooper() {
        return this.nioLooper;
    }

    private void registerTimerEvent(Duration timer, Runnable task) {
        this.nioLooper.registerTimerEvent(timer, task);
    }

    @Override
    public void handleAccept(SelectableChannel channel) {
        throw new RuntimeException("Client does not implement accept");
    }

    @Override
    public void handleConnect(SelectableChannel channel) {
        try {
            if (this.socketChannel.finishConnect()) {
                this.nioLooper.unregisterConnect(channel);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to FinishConnect to endpoint: " + this.endpoint, e);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    HeronClient.this.onConnect(StatusCode.CONNECT_ERROR);
                }
            };
            this.nioLooper.registerTimerEvent(Duration.ZERO, r);
            return;
        }
        this.socketChannelHelper = new SocketChannelHelper(this.nioLooper, this, this.socketChannel, this.socketOptions);
        this.isConnected = true;
        this.onConnect(StatusCode.OK);
    }

    protected void handlePacket(IncomingPacket incomingPacket) {
        Message.Builder bldr;
        String typeName = incomingPacket.unpackString();
        REQID rid = incomingPacket.unpackREQID();
        if (this.contextMap.containsKey(rid)) {
            Object ctx = this.contextMap.get(rid);
            Message.Builder bldr2 = this.responseMessageMap.get(rid);
            this.contextMap.remove(rid);
            this.responseMessageMap.remove(rid);
            incomingPacket.unpackMessage(bldr2);
            if (bldr2.isInitialized()) {
                Message response = bldr2.build();
                this.onResponse(StatusCode.OK, ctx, response);
                return;
            }
            this.onResponse(StatusCode.INVALID_PACKET, ctx, null);
            return;
        }
        if (rid.equals(REQID.zeroREQID) && (bldr = this.messageMap.get(typeName)) != null) {
            bldr.clear();
            incomingPacket.unpackMessage(bldr);
            if (bldr.isInitialized()) {
                this.onIncomingMessage(bldr.build());
            }
        }
    }

    protected void handleTimeout(REQID rid) {
        if (this.contextMap.containsKey(rid)) {
            Object ctx = this.contextMap.get(rid);
            this.contextMap.remove(rid);
            this.responseMessageMap.remove(rid);
            this.onResponse(StatusCode.TIMEOUT_ERROR, ctx, null);
        }
    }

    @Override
    public void handleError(SelectableChannel channel) {
        LOG.info("Handling Error. Cleaning states in HeronClient.");
        this.contextMap.clear();
        this.responseMessageMap.clear();
        this.messageMap.clear();
        this.socketChannelHelper.clear();
        this.nioLooper.removeAllInterest(channel);
        try {
            channel.close();
            LOG.info("Successfully closed the channel: " + channel);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to close connection in handleError", e);
        }
        this.isConnected = false;
        this.onError();
    }

    public void startReading() {
        this.socketChannelHelper.enableReading();
    }

    public void stopReading() {
        this.socketChannelHelper.disableReading();
    }

    public void startWriting() {
        this.socketChannelHelper.enableWriting();
    }

    public void stopWriting() {
        this.socketChannelHelper.disableWriting();
    }

    public int getOutstandingPackets() {
        return this.socketChannelHelper.getOutstandingPackets();
    }

    public void forceFlushWithBestEffort() {
        this.socketChannelHelper.forceFlushWithBestEffort();
    }

    public abstract void onError();

    public abstract void onConnect(StatusCode var1);

    public abstract void onResponse(StatusCode var1, Object var2, Message var3);

    public abstract void onIncomingMessage(Message var1);

    public abstract void onClose();

    protected Map<String, Message.Builder> getMessageMap() {
        return new HashMap<String, Message.Builder>(this.messageMap);
    }

    protected Map<REQID, Message.Builder> getResponseMessageMap() {
        return new HashMap<REQID, Message.Builder>(this.responseMessageMap);
    }

    protected Map<REQID, Object> getContextMap() {
        return new HashMap<REQID, Object>(this.contextMap);
    }

    protected SocketChannelHelper getSocketChannelHelper() {
        return this.socketChannelHelper;
    }

    protected SocketChannel getSocketChannel() {
        return this.socketChannel;
    }
}

