/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.metrics;

import org.apache.heron.api.metric.CountMetric;
import org.apache.heron.api.metric.CumulativeCountMetric;
import org.apache.heron.api.metric.MeanReducer;
import org.apache.heron.api.metric.MeanReducerState;
import org.apache.heron.api.metric.ReducedMetric;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.utils.metrics.IBoltMetrics;
import org.apache.heron.common.utils.misc.PhysicalPlanHelper;
import org.apache.heron.common.utils.topology.TopologyContextImpl;

public class BoltMetrics
implements IBoltMetrics {
    private final CountMetric ackCount = new CountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> processLatency = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final ReducedMetric<MeanReducerState, Number, Double> failLatency = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final CountMetric failCount = new CountMetric();
    private final CountMetric executeCount = new CountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> executeLatency = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final CountMetric tupleAddedToQueue;
    private final CountMetric emitCount = new CountMetric();
    private final CountMetric outQueueFullCount = new CountMetric();
    private CumulativeCountMetric taskRunCount;
    private CumulativeCountMetric executionCount;
    private CumulativeCountMetric continueWorkCount;

    public BoltMetrics() {
        this.tupleAddedToQueue = new CountMetric();
        this.taskRunCount = new CumulativeCountMetric();
        this.executionCount = new CumulativeCountMetric();
        this.continueWorkCount = new CumulativeCountMetric();
    }

    @Override
    public void registerMetrics(TopologyContextImpl topologyContext) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int interval = (int)systemConfig.getHeronMetricsExportInterval().getSeconds();
        topologyContext.registerMetric("__ack-count/default", this.ackCount, interval);
        topologyContext.registerMetric("__process-latency/default", this.processLatency, interval);
        topologyContext.registerMetric("__fail-latency/default", this.failLatency, interval);
        topologyContext.registerMetric("__fail-count/default", this.failCount, interval);
        topologyContext.registerMetric("__execute-count/default", this.executeCount, interval);
        topologyContext.registerMetric("__execute-latency/default", this.executeLatency, interval);
        topologyContext.registerMetric("__emit-count/default", this.emitCount, interval);
        topologyContext.registerMetric("__out-queue-full-count", this.outQueueFullCount, interval);
        topologyContext.registerMetric("__data-tuple-added-to-outgoing-queue/default", this.tupleAddedToQueue, interval);
        topologyContext.registerMetric("__task-run-count", this.taskRunCount, interval);
        topologyContext.registerMetric("__execution-count", this.executionCount, interval);
        topologyContext.registerMetric("__continue-work-count", this.continueWorkCount, interval);
    }

    @Override
    public void initMultiCountMetrics(PhysicalPlanHelper helper) {
    }

    @Override
    public void ackedTuple(String streamId, String sourceComponent, long latency) {
        this.ackCount.incr();
        this.processLatency.update(latency);
    }

    @Override
    public void failedTuple(String streamId, String sourceComponent, long latency) {
        this.failCount.incr();
        this.failLatency.update(latency);
    }

    @Override
    public void executeTuple(String streamId, String sourceComponent, long latency) {
        this.executeCount.incr();
        this.executeLatency.update(latency);
    }

    @Override
    public void emittedTuple(String streamId) {
        this.emitCount.incr();
    }

    @Override
    public void addTupleToQueue(int size) {
        this.tupleAddedToQueue.incr();
    }

    @Override
    public void updateOutQueueFullCount() {
        this.outQueueFullCount.incr();
    }

    @Override
    public void deserializeDataTuple(String streamId, String sourceComponent, long latency) {
    }

    @Override
    public void serializeDataTuple(String streamId, long latency) {
    }

    @Override
    public void updateTaskRunCount() {
        this.taskRunCount.incr();
    }

    @Override
    public void updateExecutionCount() {
        this.executionCount.incr();
    }

    @Override
    public void updateContinueWorkCount() {
        this.continueWorkCount.incr();
    }
}

