/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.metrics;

import java.util.List;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.metric.CountMetric;
import org.apache.heron.api.metric.CumulativeCountMetric;
import org.apache.heron.api.metric.MeanReducer;
import org.apache.heron.api.metric.MeanReducerState;
import org.apache.heron.api.metric.MultiCountMetric;
import org.apache.heron.api.metric.MultiReducedMetric;
import org.apache.heron.api.metric.ReducedMetric;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.utils.metrics.ISpoutMetrics;
import org.apache.heron.common.utils.misc.PhysicalPlanHelper;
import org.apache.heron.common.utils.topology.TopologyContextImpl;

public class FullSpoutMetrics
implements ISpoutMetrics {
    private final MultiCountMetric ackCount = new MultiCountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> tupleSize;
    private final MultiReducedMetric<MeanReducerState, Number, Double> completeLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiReducedMetric<MeanReducerState, Number, Double> failLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiCountMetric failCount = new MultiCountMetric();
    private final MultiCountMetric timeoutCount = new MultiCountMetric();
    private final MultiCountMetric emitCount = new MultiCountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> nextTupleLatency = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final CountMetric nextTupleCount = new CountMetric();
    private final MultiCountMetric serializationTimeNs;
    private final CountMetric tupleAddedToQueue;
    private final CountMetric outQueueFullCount = new CountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> pendingTuplesCount = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private CumulativeCountMetric taskRunCount;
    private CumulativeCountMetric produceTupleCount;
    private CumulativeCountMetric continueWorkCount;

    public FullSpoutMetrics() {
        this.serializationTimeNs = new MultiCountMetric();
        this.tupleAddedToQueue = new CountMetric();
        this.tupleSize = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.taskRunCount = new CumulativeCountMetric();
        this.produceTupleCount = new CumulativeCountMetric();
        this.continueWorkCount = new CumulativeCountMetric();
    }

    @Override
    public void registerMetrics(TopologyContextImpl topologyContext) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int interval = (int)systemConfig.getHeronMetricsExportInterval().getSeconds();
        topologyContext.registerMetric("__ack-count", this.ackCount, interval);
        topologyContext.registerMetric("__complete-latency", this.completeLatency, interval);
        topologyContext.registerMetric("__fail-latency", this.failLatency, interval);
        topologyContext.registerMetric("__fail-count", this.failCount, interval);
        topologyContext.registerMetric("__timeout-count", this.timeoutCount, interval);
        topologyContext.registerMetric("__emit-count", this.emitCount, interval);
        topologyContext.registerMetric("__next-tuple-latency", this.nextTupleLatency, interval);
        topologyContext.registerMetric("__next-tuple-count", this.nextTupleCount, interval);
        topologyContext.registerMetric("__out-queue-full-count", this.outQueueFullCount, interval);
        topologyContext.registerMetric("__pending-acked-count", this.pendingTuplesCount, interval);
        topologyContext.registerMetric("__tuple-serialization-time-ns", this.serializationTimeNs, interval);
        topologyContext.registerMetric("__task-run-count", this.taskRunCount, interval);
        topologyContext.registerMetric("__produce-tuple-count", this.produceTupleCount, interval);
        topologyContext.registerMetric("__continue-work-count", this.continueWorkCount, interval);
        topologyContext.registerMetric("__data-tuple-added-to-outgoing-queue/default", this.tupleAddedToQueue, interval);
        topologyContext.registerMetric("__average-tuple-size-added-queue/default", this.tupleSize, interval);
    }

    @Override
    public void initMultiCountMetrics(PhysicalPlanHelper helper) {
        List<TopologyAPI.OutputStream> outputs = helper.getMySpout().getOutputsList();
        for (TopologyAPI.OutputStream outputStream : outputs) {
            String streamId = outputStream.getStream().getId();
            this.ackCount.scope(streamId);
            this.failCount.scope(streamId);
            this.timeoutCount.scope(streamId);
            this.emitCount.scope(streamId);
        }
    }

    @Override
    public void ackedTuple(String streamId, long latency) {
        this.ackCount.scope(streamId).incr();
        this.completeLatency.scope(streamId).update(latency);
    }

    @Override
    public void failedTuple(String streamId, long latency) {
        this.failCount.scope(streamId).incr();
        this.failLatency.scope(streamId).update(latency);
    }

    @Override
    public void timeoutTuple(String streamId) {
        this.timeoutCount.scope(streamId).incr();
    }

    @Override
    public void emittedTuple(String streamId) {
        this.emitCount.scope(streamId).incr();
    }

    @Override
    public void nextTuple(long latency) {
        this.nextTupleLatency.update(latency);
        this.nextTupleCount.incr();
    }

    @Override
    public void addTupleToQueue(int size) {
        this.tupleAddedToQueue.incr();
        this.tupleSize.update(size);
    }

    @Override
    public void updateOutQueueFullCount() {
        this.outQueueFullCount.incr();
    }

    @Override
    public void updatePendingTuplesCount(long count) {
        this.pendingTuplesCount.update(count);
    }

    @Override
    public void serializeDataTuple(String streamId, long latency) {
        this.serializationTimeNs.scope(streamId).incrBy(latency);
    }

    @Override
    public void updateTaskRunCount() {
        this.taskRunCount.incr();
    }

    @Override
    public void updateProduceTupleCount() {
        this.produceTupleCount.incr();
    }

    @Override
    public void updateContinueWorkCount() {
        this.continueWorkCount.incr();
    }
}

