/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.metrics;

import com.sun.management.OperatingSystemMXBean;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.time.Duration;
import java.util.List;
import org.apache.heron.api.metric.AssignableMetric;
import org.apache.heron.api.metric.MeanReducer;
import org.apache.heron.api.metric.MeanReducerState;
import org.apache.heron.api.metric.MultiAssignableMetric;
import org.apache.heron.api.metric.ReducedMetric;
import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.utils.metrics.MetricsCollector;

public class JVMMetrics {
    private final Runtime runtime = Runtime.getRuntime();
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    private final RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private final java.lang.management.OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final List<MemoryPoolMXBean> memoryPoolMXBeanList = ManagementFactory.getMemoryPoolMXBeans();
    private final List<BufferPoolMXBean> bufferPoolMXBeanList = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    private final MultiAssignableMetric<Long> jvmGCTimeMsPerGCType;
    private final MultiAssignableMetric<Long> jvmGCCountPerGCType;
    private final AssignableMetric<Integer> jvmThreadCount;
    private final AssignableMetric<Integer> jvmDaemonThreadCount;
    private final AssignableMetric<Long> fdCount;
    private final AssignableMetric<Long> fdLimit;
    private AssignableMetric<Long> jvmGCTimeMs = new AssignableMetric<Long>(0L);
    private AssignableMetric<Long> jvmGCCount = new AssignableMetric<Long>(0L);
    private AssignableMetric<Long> jvmUpTimeSecs;
    private AssignableMetric<Long> processCPUTimeNs;
    private MultiAssignableMetric<Long> threadsCPUTimeNs;
    private AssignableMetric<Long> otherThreadsCPUTimeNs;
    private MultiAssignableMetric<Long> threadsUserCPUTimeNs;
    private AssignableMetric<Long> otherThreadsUserCPUTimeNs;
    private ReducedMetric<MeanReducerState, Number, Double> processCPULoad;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryFreeMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryUsedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryTotalMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryHeapUsedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryHeapCommittedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryHeapMaxMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryNonHeapUsedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryNonHeapCommittedMB;
    private ReducedMetric<MeanReducerState, Number, Double> jvmMemoryNonHeapMaxMB;
    private MultiAssignableMetric<Long> jvmPeakUsagePerMemoryPool;
    private MultiAssignableMetric<Long> jvmCollectionUsagePerMemoryPool;
    private MultiAssignableMetric<Long> jvmEstimatedUsagePerMemoryPool;
    private MultiAssignableMetric<Long> jvmBufferPoolMemoryUsage;

    public JVMMetrics() {
        this.jvmGCCountPerGCType = new MultiAssignableMetric<Long>(0L);
        this.jvmGCTimeMsPerGCType = new MultiAssignableMetric<Long>(0L);
        this.jvmUpTimeSecs = new AssignableMetric<Long>(0L);
        this.jvmThreadCount = new AssignableMetric<Integer>(0);
        this.jvmDaemonThreadCount = new AssignableMetric<Integer>(0);
        this.processCPUTimeNs = new AssignableMetric<Long>(0L);
        this.threadsCPUTimeNs = new MultiAssignableMetric<Long>(0L);
        this.otherThreadsCPUTimeNs = new AssignableMetric<Long>(0L);
        this.threadsUserCPUTimeNs = new MultiAssignableMetric<Long>(0L);
        this.otherThreadsUserCPUTimeNs = new AssignableMetric<Long>(0L);
        this.processCPULoad = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.fdCount = new AssignableMetric<Long>(0L);
        this.fdLimit = new AssignableMetric<Long>(0L);
        this.jvmMemoryFreeMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryUsedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryTotalMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryHeapUsedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryHeapCommittedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryHeapMaxMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryNonHeapUsedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryNonHeapCommittedMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmMemoryNonHeapMaxMB = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.jvmPeakUsagePerMemoryPool = new MultiAssignableMetric<Long>(0L);
        this.jvmCollectionUsagePerMemoryPool = new MultiAssignableMetric<Long>(0L);
        this.jvmEstimatedUsagePerMemoryPool = new MultiAssignableMetric<Long>(0L);
        this.jvmBufferPoolMemoryUsage = new MultiAssignableMetric<Long>(0L);
    }

    public void registerMetrics(MetricsCollector metricsCollector) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int interval = (int)systemConfig.getHeronMetricsExportInterval().getSeconds();
        metricsCollector.registerMetric("__jvm-gc-collection-time-ms", this.jvmGCTimeMs, interval);
        metricsCollector.registerMetric("__jvm-gc-collection-count", this.jvmGCCount, interval);
        metricsCollector.registerMetric("__jvm-gc-time-ms", this.jvmGCTimeMsPerGCType, interval);
        metricsCollector.registerMetric("__jvm-gc-count", this.jvmGCCountPerGCType, interval);
        metricsCollector.registerMetric("__jvm-uptime-secs", this.jvmUpTimeSecs, interval);
        metricsCollector.registerMetric("__jvm-thread-count", this.jvmThreadCount, interval);
        metricsCollector.registerMetric("__jvm-daemon-thread-count", this.jvmDaemonThreadCount, interval);
        metricsCollector.registerMetric("__jvm-process-cpu-time-nanos", this.processCPUTimeNs, interval);
        metricsCollector.registerMetric("__jvm-threads-cpu-time-nanos", this.threadsCPUTimeNs, interval);
        metricsCollector.registerMetric("__jvm-other-threads-cpu-time-nanos", this.otherThreadsCPUTimeNs, interval);
        metricsCollector.registerMetric("__jvm-threads-user-cpu-time-nanos", this.threadsUserCPUTimeNs, interval);
        metricsCollector.registerMetric("__jvm-other-threads-user-cpu-time-nanos", this.otherThreadsUserCPUTimeNs, interval);
        metricsCollector.registerMetric("__jvm-process-cpu-load", this.processCPULoad, interval);
        metricsCollector.registerMetric("__jvm-fd-count", this.fdCount, interval);
        metricsCollector.registerMetric("__jvm-fd-limit", this.fdLimit, interval);
        metricsCollector.registerMetric("__jvm-memory-free-mb", this.jvmMemoryFreeMB, interval);
        metricsCollector.registerMetric("__jvm-memory-used-mb", this.jvmMemoryUsedMB, interval);
        metricsCollector.registerMetric("__jvm-memory-mb-total", this.jvmMemoryTotalMB, interval);
        metricsCollector.registerMetric("__jvm-memory-heap-mb-used", this.jvmMemoryHeapUsedMB, interval);
        metricsCollector.registerMetric("__jvm-memory-heap-mb-committed", this.jvmMemoryHeapCommittedMB, interval);
        metricsCollector.registerMetric("__jvm-memory-heap-mb-max", this.jvmMemoryHeapMaxMB, interval);
        metricsCollector.registerMetric("__jvm-memory-non-heap-mb-used", this.jvmMemoryNonHeapUsedMB, interval);
        metricsCollector.registerMetric("__jvm-memory-non-heap-mb-committed", this.jvmMemoryNonHeapCommittedMB, interval);
        metricsCollector.registerMetric("__jvm-memory-non-heap-mb-max", this.jvmMemoryNonHeapMaxMB, interval);
        metricsCollector.registerMetric("__jvm-peak-usage", this.jvmPeakUsagePerMemoryPool, interval);
        metricsCollector.registerMetric("__jvm-collection-usage", this.jvmCollectionUsagePerMemoryPool, interval);
        metricsCollector.registerMetric("__jvm-estimated-usage", this.jvmEstimatedUsagePerMemoryPool, interval);
        metricsCollector.registerMetric("__jvm-buffer-pool", this.jvmBufferPoolMemoryUsage, interval);
    }

    public Runnable getJVMSampleRunnable() {
        Runnable sampleRunnable = new Runnable(){

            @Override
            public void run() {
                JVMMetrics.this.updateGcMetrics();
                JVMMetrics.this.jvmUpTimeSecs.setValue(Duration.ofMillis(JVMMetrics.this.runtimeMXBean.getUptime()).getSeconds());
                JVMMetrics.this.processCPUTimeNs.setValue(JVMMetrics.this.getProcessCPUTimeNs());
                JVMMetrics.this.getThreadsMetrics();
                JVMMetrics.this.processCPULoad.update(JVMMetrics.this.getProcessCPULoad() * (double)JVMMetrics.this.runtime.availableProcessors());
                JVMMetrics.this.updateFdMetrics();
                JVMMetrics.this.updateMemoryPoolMetrics();
                JVMMetrics.this.updateBufferPoolMetrics();
                ByteAmount freeMemory = ByteAmount.fromBytes(JVMMetrics.this.runtime.freeMemory());
                ByteAmount totalMemory = ByteAmount.fromBytes(JVMMetrics.this.runtime.totalMemory());
                JVMMetrics.this.jvmMemoryFreeMB.update(freeMemory.asMegabytes());
                JVMMetrics.this.jvmMemoryTotalMB.update(totalMemory.asMegabytes());
                JVMMetrics.this.jvmMemoryUsedMB.update(totalMemory.asMegabytes() - freeMemory.asMegabytes());
                JVMMetrics.this.jvmMemoryHeapUsedMB.update(ByteAmount.fromBytes(JVMMetrics.this.memoryBean.getHeapMemoryUsage().getUsed()).asMegabytes());
                JVMMetrics.this.jvmMemoryHeapCommittedMB.update(ByteAmount.fromBytes(JVMMetrics.this.memoryBean.getHeapMemoryUsage().getCommitted()).asMegabytes());
                JVMMetrics.this.jvmMemoryHeapMaxMB.update(ByteAmount.fromBytes(JVMMetrics.this.memoryBean.getHeapMemoryUsage().getMax()).asMegabytes());
                JVMMetrics.this.jvmMemoryNonHeapUsedMB.update(ByteAmount.fromBytes(JVMMetrics.this.memoryBean.getNonHeapMemoryUsage().getUsed()).asMegabytes());
                JVMMetrics.this.jvmMemoryNonHeapCommittedMB.update(ByteAmount.fromBytes(JVMMetrics.this.memoryBean.getNonHeapMemoryUsage().getCommitted()).asMegabytes());
                JVMMetrics.this.jvmMemoryNonHeapMaxMB.update(ByteAmount.fromBytes(JVMMetrics.this.memoryBean.getNonHeapMemoryUsage().getMax()).asMegabytes());
            }
        };
        return sampleRunnable;
    }

    private void updateBufferPoolMetrics() {
        for (BufferPoolMXBean bufferPoolMXBean : this.bufferPoolMXBeanList) {
            String normalizedKeyName = bufferPoolMXBean.getName().replaceAll("[^\\w]", "-");
            ByteAmount memoryUsed = ByteAmount.fromBytes(bufferPoolMXBean.getMemoryUsed());
            ByteAmount totalCapacity = ByteAmount.fromBytes(bufferPoolMXBean.getTotalCapacity());
            ByteAmount count = ByteAmount.fromBytes(bufferPoolMXBean.getCount());
            this.jvmBufferPoolMemoryUsage.safeScope(normalizedKeyName + "-memory-used").setValue(memoryUsed.asMegabytes());
            this.jvmBufferPoolMemoryUsage.safeScope(normalizedKeyName + "-total-capacity").setValue(totalCapacity.asMegabytes());
            this.jvmBufferPoolMemoryUsage.safeScope(normalizedKeyName + "-count").setValue(count.asMegabytes());
        }
    }

    private void updateMemoryPoolMetrics() {
        for (MemoryPoolMXBean memoryPoolMXBean : this.memoryPoolMXBeanList) {
            MemoryUsage estimatedUsage;
            MemoryUsage collectionUsage;
            String normalizedKeyName = memoryPoolMXBean.getName().replaceAll("[^\\w]", "-");
            MemoryUsage peakUsage = memoryPoolMXBean.getPeakUsage();
            if (peakUsage != null) {
                this.jvmPeakUsagePerMemoryPool.safeScope(normalizedKeyName + "-used").setValue(ByteAmount.fromBytes(peakUsage.getUsed()).asMegabytes());
                this.jvmPeakUsagePerMemoryPool.safeScope(normalizedKeyName + "-committed").setValue(ByteAmount.fromBytes(peakUsage.getCommitted()).asMegabytes());
                this.jvmPeakUsagePerMemoryPool.safeScope(normalizedKeyName + "-max").setValue(ByteAmount.fromBytes(peakUsage.getMax()).asMegabytes());
            }
            if ((collectionUsage = memoryPoolMXBean.getCollectionUsage()) != null) {
                this.jvmCollectionUsagePerMemoryPool.safeScope(normalizedKeyName + "-used").setValue(ByteAmount.fromBytes(collectionUsage.getUsed()).asMegabytes());
                this.jvmCollectionUsagePerMemoryPool.safeScope(normalizedKeyName + "-committed").setValue(ByteAmount.fromBytes(collectionUsage.getCommitted()).asMegabytes());
                this.jvmCollectionUsagePerMemoryPool.safeScope(normalizedKeyName + "-max").setValue(ByteAmount.fromBytes(collectionUsage.getMax()).asMegabytes());
            }
            if ((estimatedUsage = memoryPoolMXBean.getUsage()) == null) continue;
            this.jvmEstimatedUsagePerMemoryPool.safeScope(normalizedKeyName + "-used").setValue(ByteAmount.fromBytes(estimatedUsage.getUsed()).asMegabytes());
            this.jvmEstimatedUsagePerMemoryPool.safeScope(normalizedKeyName + "-committed").setValue(ByteAmount.fromBytes(estimatedUsage.getCommitted()).asMegabytes());
            this.jvmEstimatedUsagePerMemoryPool.safeScope(normalizedKeyName + "-max").setValue(ByteAmount.fromBytes(estimatedUsage.getMax()).asMegabytes());
        }
    }

    private void getThreadsMetrics() {
        if (this.threadMXBean.isThreadCpuTimeSupported()) {
            this.threadMXBean.setThreadCpuTimeEnabled(true);
            long tmpOtherThreadsCpuTime = 0L;
            long tmpOtherThreadsUserCpuTime = 0L;
            for (long id : this.threadMXBean.getAllThreadIds()) {
                long cpuTime = this.threadMXBean.getThreadCpuTime(id);
                long cpuUserTime = this.threadMXBean.getThreadUserTime(id);
                ThreadInfo threadInfo = this.threadMXBean.getThreadInfo(id);
                if (threadInfo == null) continue;
                String threadName = threadInfo.getThreadName();
                if (threadName.equals("GatewayThread") || threadName.equals("SlaveThread")) {
                    this.threadsCPUTimeNs.scope(threadName).setValue(cpuTime);
                    this.threadsUserCPUTimeNs.scope(threadName).setValue(cpuUserTime);
                    continue;
                }
                tmpOtherThreadsCpuTime += cpuTime;
                tmpOtherThreadsUserCpuTime += cpuUserTime;
            }
            this.otherThreadsCPUTimeNs.setValue(tmpOtherThreadsCpuTime);
            this.otherThreadsUserCPUTimeNs.setValue(tmpOtherThreadsUserCpuTime);
            this.jvmThreadCount.setValue(this.threadMXBean.getThreadCount());
            this.jvmDaemonThreadCount.setValue(this.threadMXBean.getDaemonThreadCount());
        }
    }

    private void updateGcMetrics() {
        this.updateGcTimes();
        this.updateGcCounts();
    }

    private void updateGcTimes() {
        long totalTimeMs = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectionTimeMs = bean.getCollectionTime();
            totalTimeMs += collectionTimeMs;
            String normalizedKeyName = bean.getName().replaceAll("[^\\w]", "-");
            this.jvmGCTimeMsPerGCType.safeScope(normalizedKeyName).setValue(collectionTimeMs);
        }
        this.jvmGCTimeMs.setValue(totalTimeMs);
    }

    private void updateGcCounts() {
        long totalCount = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long collectionCount = bean.getCollectionCount();
            totalCount += collectionCount;
            String normalizedKeyName = bean.getName().replaceAll("[^\\w]", "-");
            this.jvmGCCountPerGCType.safeScope(normalizedKeyName).setValue(collectionCount);
        }
        this.jvmGCCount.setValue(totalCount);
    }

    private long getProcessCPUTimeNs() {
        if (this.osMbean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOsMbean = (OperatingSystemMXBean)this.osMbean;
            return sunOsMbean.getProcessCpuTime();
        }
        return -1L;
    }

    private double getProcessCPULoad() {
        if (this.osMbean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean sunOsMbean = (OperatingSystemMXBean)this.osMbean;
            return sunOsMbean.getProcessCpuLoad();
        }
        return -1.0;
    }

    private void updateFdMetrics() {
        if (this.osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unix = (UnixOperatingSystemMXBean)this.osMbean;
            this.fdCount.setValue(unix.getOpenFileDescriptorCount());
            this.fdLimit.setValue(unix.getMaxFileDescriptorCount());
        }
    }
}

